/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GlobalRailwayManager;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.schedule.DestinationSuggestions;
import com.simibubi.create.content.logistics.trains.management.schedule.IScheduleInput;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleContainer;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleDataEntry;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEditPacket;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEntry;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ModularGuiLine;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.container.GhostItemSubmitPacket;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.ScreenUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class ScheduleScreen
extends AbstractSimiContainerScreen<ScheduleContainer> {
    private static final int CARD_HEADER = 22;
    private static final int CARD_WIDTH = 195;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private List<LerpedFloat> horizontalScrolls = new ArrayList<LerpedFloat>();
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private Schedule schedule;
    private IconButton confirmButton;
    private IconButton cyclicButton;
    private Indicator cyclicIndicator;
    private IconButton resetProgress;
    private IconButton skipProgress;
    private ScheduleInstruction editingDestination;
    private ScheduleWaitCondition editingCondition;
    private SelectionScrollInput scrollInput;
    private Label scrollInputLabel;
    private IconButton editorConfirm;
    private IconButton editorDelete;
    private ModularGuiLine editorSubWidgets;
    private Consumer<Boolean> onEditorClose;
    private DestinationSuggestions destinationSuggestions;
    private Component clickToEdit = Lang.translateDirect("gui.schedule.lmb_edit", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});
    private Component rClickToDelete = Lang.translateDirect("gui.schedule.rmb_remove", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});

    public ScheduleScreen(ScheduleContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.schedule = new Schedule();
        CompoundTag tag = ((ItemStack)container.contentHolder).m_41784_().m_128469_("Schedule");
        if (!tag.m_128456_()) {
            this.schedule = Schedule.fromTag(tag);
        }
        container.slotsActive = false;
        this.editorSubWidgets = new ModularGuiLine();
    }

    @Override
    protected void m_7856_() {
        AllGuiTextures bg = AllGuiTextures.SCHEDULE;
        this.setWindowSize(bg.width, bg.height);
        super.m_7856_();
        this.m_169413_();
        this.confirmButton = new IconButton(this.f_97735_ + bg.width - 42, this.f_97736_ + bg.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.m_142416_(this.confirmButton);
        this.cyclicIndicator = new Indicator(this.f_97735_ + 21, this.f_97736_ + 196, Components.immutableEmpty());
        this.cyclicIndicator.state = this.schedule.cyclic ? Indicator.State.ON : Indicator.State.OFF;
        this.m_142416_(this.cyclicIndicator);
        this.cyclicButton = new IconButton(this.f_97735_ + 21, this.f_97736_ + 202, AllIcons.I_REFRESH);
        this.cyclicButton.withCallback(() -> {
            this.schedule.cyclic = !this.schedule.cyclic;
            this.cyclicIndicator.state = this.schedule.cyclic ? Indicator.State.ON : Indicator.State.OFF;
        });
        List<Component> tip = this.cyclicButton.getToolTip();
        tip.add((Component)Lang.translateDirect("schedule.loop", new Object[0]));
        tip.add((Component)Lang.translateDirect("schedule.loop1", new Object[0]).m_130940_(ChatFormatting.GRAY));
        tip.add((Component)Lang.translateDirect("schedule.loop2", new Object[0]).m_130940_(ChatFormatting.GRAY));
        this.m_142416_(this.cyclicButton);
        this.resetProgress = new IconButton(this.f_97735_ + 45, this.f_97736_ + 202, AllIcons.I_PRIORITY_VERY_HIGH);
        this.resetProgress.withCallback(() -> {
            this.schedule.savedProgress = 0;
            this.resetProgress.f_93623_ = false;
        });
        this.resetProgress.f_93623_ = this.schedule.savedProgress > 0 && !this.schedule.entries.isEmpty();
        this.resetProgress.setToolTip((Component)Lang.translateDirect("schedule.reset", new Object[0]));
        this.m_142416_(this.resetProgress);
        this.skipProgress = new IconButton(this.f_97735_ + 63, this.f_97736_ + 202, AllIcons.I_PRIORITY_LOW);
        this.skipProgress.withCallback(() -> {
            ++this.schedule.savedProgress;
            this.schedule.savedProgress %= this.schedule.entries.size();
            this.resetProgress.f_93623_ = this.schedule.savedProgress > 0;
        });
        this.skipProgress.f_93623_ = this.schedule.entries.size() > 1;
        this.skipProgress.setToolTip((Component)Lang.translateDirect("schedule.skip", new Object[0]));
        this.m_142416_(this.skipProgress);
        this.stopEditing();
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.f_97735_ + bg.width, this.f_97736_ + bg.height - 56, 48, 48));
        this.horizontalScrolls.clear();
        for (int i = 0; i < this.schedule.entries.size(); ++i) {
            this.horizontalScrolls.add(LerpedFloat.linear().startWithValue(0.0));
        }
    }

    protected void startEditing(IScheduleInput field, Consumer<Boolean> onClose, boolean allowDeletion) {
        int i;
        this.onEditorClose = onClose;
        this.confirmButton.f_93624_ = false;
        this.cyclicButton.f_93624_ = false;
        this.cyclicIndicator.f_93624_ = false;
        this.skipProgress.f_93624_ = false;
        this.resetProgress.f_93624_ = false;
        this.scrollInput = new SelectionScrollInput(this.f_97735_ + 56, this.f_97736_ + 65, 143, 16);
        this.scrollInputLabel = new Label(this.f_97735_ + 59, this.f_97736_ + 69, Components.immutableEmpty()).withShadow();
        this.editorConfirm = new IconButton(this.f_97735_ + 56 + 168, this.f_97736_ + 65 + 22, AllIcons.I_CONFIRM);
        if (allowDeletion) {
            this.editorDelete = new IconButton(this.f_97735_ + 56 - 45, this.f_97736_ + 65 + 22, AllIcons.I_TRASH);
        }
        ((ScheduleContainer)this.f_97732_).slotsActive = true;
        ((ScheduleContainer)this.f_97732_).targetSlotsActive = field.slotsTargeted();
        for (int i2 = 0; i2 < field.slotsTargeted(); ++i2) {
            ItemStack item = field.getItem(i2);
            ((ScheduleContainer)this.f_97732_).ghostInventory.setStackInSlot(i2, item);
            AllPackets.channel.sendToServer((Object)new GhostItemSubmitPacket(item, i2));
        }
        if (field instanceof ScheduleInstruction) {
            ScheduleInstruction instruction = (ScheduleInstruction)field;
            int startIndex = 0;
            for (i = 0; i < Schedule.INSTRUCTION_TYPES.size(); ++i) {
                if (!Schedule.INSTRUCTION_TYPES.get(i).getFirst().equals((Object)instruction.getId())) continue;
                startIndex = i;
            }
            this.editingDestination = instruction;
            this.updateEditorSubwidgets(this.editingDestination);
            this.scrollInput.forOptions(Schedule.getTypeOptions(Schedule.INSTRUCTION_TYPES)).titled(Lang.translateDirect("schedule.instruction_type", new Object[0])).writingTo(this.scrollInputLabel).calling(index -> {
                ScheduleInstruction newlyCreated = Schedule.INSTRUCTION_TYPES.get((int)index).getSecond().get();
                if (this.editingDestination.getId().equals((Object)newlyCreated.getId())) {
                    return;
                }
                this.editingDestination = newlyCreated;
                this.updateEditorSubwidgets(this.editingDestination);
            }).setState(startIndex);
        }
        if (field instanceof ScheduleWaitCondition) {
            ScheduleWaitCondition cond = (ScheduleWaitCondition)field;
            int startIndex = 0;
            for (i = 0; i < Schedule.CONDITION_TYPES.size(); ++i) {
                if (!Schedule.CONDITION_TYPES.get(i).getFirst().equals((Object)cond.getId())) continue;
                startIndex = i;
            }
            this.editingCondition = cond;
            this.updateEditorSubwidgets(this.editingCondition);
            this.scrollInput.forOptions(Schedule.getTypeOptions(Schedule.CONDITION_TYPES)).titled(Lang.translateDirect("schedule.condition_type", new Object[0])).writingTo(this.scrollInputLabel).calling(index -> {
                ScheduleWaitCondition newlyCreated = Schedule.CONDITION_TYPES.get((int)index).getSecond().get();
                if (this.editingCondition.getId().equals((Object)newlyCreated.getId())) {
                    return;
                }
                this.editingCondition = newlyCreated;
                this.updateEditorSubwidgets(this.editingCondition);
            }).setState(startIndex);
        }
        this.m_142416_(this.scrollInput);
        this.m_142416_(this.scrollInputLabel);
        this.m_142416_(this.editorConfirm);
        if (allowDeletion) {
            this.m_142416_(this.editorDelete);
        }
    }

    private void onDestinationEdited(String text) {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.m_93881_();
        }
    }

    protected void stopEditing() {
        this.confirmButton.f_93624_ = true;
        this.cyclicButton.f_93624_ = true;
        this.cyclicIndicator.f_93624_ = true;
        this.skipProgress.f_93624_ = true;
        this.resetProgress.f_93624_ = true;
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        this.destinationSuggestions = null;
        this.m_169411_(this.scrollInput);
        this.m_169411_(this.scrollInputLabel);
        this.m_169411_(this.editorConfirm);
        this.m_169411_(this.editorDelete);
        ScheduleDataEntry editing = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        for (int i = 0; i < editing.slotsTargeted(); ++i) {
            editing.setItem(i, ((ScheduleContainer)this.f_97732_).ghostInventory.getStackInSlot(i));
            AllPackets.channel.sendToServer((Object)new GhostItemSubmitPacket(ItemStack.f_41583_, i));
        }
        this.editorSubWidgets.saveValues(editing.getData());
        this.editorSubWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.editorSubWidgets.clear();
        this.editingCondition = null;
        this.editingDestination = null;
        this.editorConfirm = null;
        this.editorDelete = null;
        ((ScheduleContainer)this.f_97732_).slotsActive = false;
        this.m_7856_();
    }

    protected void updateEditorSubwidgets(IScheduleInput field) {
        this.destinationSuggestions = null;
        ((ScheduleContainer)this.f_97732_).targetSlotsActive = field.slotsTargeted();
        this.editorSubWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.editorSubWidgets.clear();
        field.initConfigurationWidgets(new ModularGuiLineBuilder(this.f_96547_, this.editorSubWidgets, this.getGuiLeft() + 77, this.getGuiTop() + 92).speechBubble());
        this.editorSubWidgets.loadValues(field.getData(), x$0 -> {
            NarratableEntry cfr_ignored_0 = (NarratableEntry)this.m_142416_((GuiEventListener)x$0);
        }, x$0 -> {
            NarratableEntry cfr_ignored_0 = (NarratableEntry)this.m_169394_((Renderable)x$0);
        });
        if (!(field instanceof DestinationInstruction)) {
            return;
        }
        this.editorSubWidgets.forEach(e -> {
            if (!(e instanceof EditBox)) {
                return;
            }
            EditBox destinationBox = (EditBox)e;
            this.destinationSuggestions = new DestinationSuggestions(this.f_96541_, (Screen)this, destinationBox, this.f_96547_, this.getViableStations(field), this.f_97736_ + 33);
            this.destinationSuggestions.m_93922_(true);
            this.destinationSuggestions.m_93881_();
            destinationBox.m_94151_(this::onDestinationEdited);
        });
    }

    private List<IntAttached<String>> getViableStations(IScheduleInput field) {
        GlobalRailwayManager railwayManager = Create.RAILWAYS.sided(null);
        HashSet<TrackGraph> viableGraphs = new HashSet<TrackGraph>(railwayManager.trackNetworks.values());
        for (ScheduleEntry entry : this.schedule.entries) {
            String filter;
            DestinationInstruction destination;
            ScheduleInstruction scheduleInstruction = entry.instruction;
            if (!(scheduleInstruction instanceof DestinationInstruction) || (destination = (DestinationInstruction)scheduleInstruction) == field || (filter = destination.getFilterForRegex()).isBlank()) continue;
            Iterator iterator = viableGraphs.iterator();
            block1: while (iterator.hasNext()) {
                TrackGraph trackGraph = (TrackGraph)iterator.next();
                for (GlobalStation station2 : trackGraph.getPoints(EdgePointType.STATION)) {
                    if (!station2.name.matches(filter)) continue;
                    continue block1;
                }
                iterator.remove();
            }
        }
        if (viableGraphs.isEmpty()) {
            viableGraphs = new HashSet<TrackGraph>(railwayManager.trackNetworks.values());
        }
        Vec3 position = this.f_96541_.f_91074_.m_20182_();
        HashSet visited = new HashSet();
        return viableGraphs.stream().flatMap(g -> g.getPoints(EdgePointType.STATION).stream()).filter(station -> station.tilePos != null).filter(station -> visited.add(station.name)).map(station -> IntAttached.with((int)Vec3.m_82539_((Vec3i)station.tilePos).m_82554_(position), station.name)).toList();
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.scroll.tickChaser();
        for (LerpedFloat lerpedFloat : this.horizontalScrolls) {
            lerpedFloat.tickChaser();
        }
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.tick();
        }
        this.schedule.savedProgress = this.schedule.entries.isEmpty() ? 0 : Mth.m_14045_((int)this.schedule.savedProgress, (int)0, (int)(this.schedule.entries.size() - 1));
        this.resetProgress.f_93623_ = this.schedule.savedProgress > 0;
        this.skipProgress.f_93623_ = this.schedule.entries.size() > 1;
    }

    @Override
    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.f_96541_.m_91296_();
        if (((ScheduleContainer)this.f_97732_).slotsActive) {
            super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            this.m_7333_(matrixStack);
            this.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
            for (Renderable widget : this.f_169369_) {
                widget.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
            }
            this.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderSchedule(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        UIRenderHelper.swapAndBlitColor(this.f_96541_.m_91385_(), UIRenderHelper.framebuffer);
        UIRenderHelper.drawStretched(matrixStack, this.f_97735_ + 33, this.f_97736_ + 16, 3, 173, -100, AllGuiTextures.SCHEDULE_STRIP_DARK);
        int yOffset = 25;
        List<ScheduleEntry> entries = this.schedule.entries;
        float scrollOffset = -this.scroll.getValue(partialTicks);
        for (int i = 0; i <= entries.size(); ++i) {
            if (this.schedule.savedProgress == i && !this.schedule.entries.isEmpty()) {
                matrixStack.m_85836_();
                float expectedY = scrollOffset + (float)this.f_97736_ + (float)yOffset + 4.0f;
                float actualY = Mth.m_14036_((float)expectedY, (float)(this.f_97736_ + 18), (float)(this.f_97736_ + 170));
                matrixStack.m_252880_(0.0f, actualY, 0.0f);
                (expectedY == actualY ? AllGuiTextures.SCHEDULE_POINTER : AllGuiTextures.SCHEDULE_POINTER_OFFSCREEN).render(matrixStack, this.f_97735_, 0);
                matrixStack.m_85849_();
            }
            this.startStencil(matrixStack, this.f_97735_ + 16, this.f_97736_ + 16, 220.0f, 173.0f);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, scrollOffset, 0.0f);
            if (i == 0 || entries.size() == 0) {
                UIRenderHelper.drawStretched(matrixStack, this.f_97735_ + 33, this.f_97736_ + 16, 3, 10, -100, AllGuiTextures.SCHEDULE_STRIP_LIGHT);
            }
            if (i == entries.size()) {
                if (i > 0) {
                    yOffset += 9;
                }
                AllGuiTextures.SCHEDULE_STRIP_END.render(matrixStack, this.f_97735_ + 29, this.f_97736_ + yOffset);
                AllGuiTextures.SCHEDULE_CARD_NEW.render(matrixStack, this.f_97735_ + 43, this.f_97736_ + yOffset);
                matrixStack.m_85849_();
                this.endStencil();
                break;
            }
            ScheduleEntry scheduleEntry = entries.get(i);
            int cardY = yOffset;
            int cardHeight = this.renderScheduleEntry(matrixStack, scheduleEntry, cardY, mouseX, mouseY, partialTicks);
            yOffset += cardHeight;
            if (i + 1 < entries.size()) {
                AllGuiTextures.SCHEDULE_STRIP_DOTTED.render(matrixStack, this.f_97735_ + 29, this.f_97736_ + yOffset - 3);
                yOffset += 10;
            }
            matrixStack.m_85849_();
            this.endStencil();
            if (!scheduleEntry.instruction.supportsConditions()) continue;
            float y1 = (float)(cardY + 24) + scrollOffset;
            float h = cardHeight - 26;
            float y2 = y1 + h;
            if (y2 > 189.0f) {
                h -= y2 - 189.0f;
            }
            if (y1 < 16.0f) {
                float correction = 16.0f - y1;
                y1 += correction;
                h -= correction;
            }
            if (h <= 0.0f) continue;
            this.startStencil(matrixStack, this.f_97735_ + 43, (float)this.f_97736_ + y1, 161.0f, h);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, scrollOffset, 0.0f);
            this.renderScheduleConditions(matrixStack, scheduleEntry, cardY, mouseX, mouseY, partialTicks, cardHeight, i);
            matrixStack.m_85849_();
            this.endStencil();
            if (!this.isConditionAreaScrollable(scheduleEntry)) continue;
            this.startStencil(matrixStack, this.f_97735_ + 16, this.f_97736_ + 16, 220.0f, 173.0f);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, scrollOffset, 0.0f);
            int center = (cardHeight - 8 + 22) / 2;
            float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
            if (!Mth.m_14033_((float)chaseTarget, (float)0.0f)) {
                AllGuiTextures.SCHEDULE_SCROLL_LEFT.render(matrixStack, this.f_97735_ + 40, this.f_97736_ + cardY + center);
            }
            if (!Mth.m_14033_((float)chaseTarget, (float)(scheduleEntry.conditions.size() - 1))) {
                AllGuiTextures.SCHEDULE_SCROLL_RIGHT.render(matrixStack, this.f_97735_ + 203, this.f_97736_ + cardY + center);
            }
            matrixStack.m_85849_();
            this.endStencil();
        }
        int zLevel = 200;
        Matrix4f mat = matrixStack.m_85850_().m_252922_();
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(this.f_97735_ + 16), (int)(this.f_97736_ + 16), (int)(this.f_97735_ + 16 + 220), (int)(this.f_97736_ + 16 + 10), (int)0x77000000, (int)0);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(this.f_97735_ + 16), (int)(this.f_97736_ + 179), (int)(this.f_97735_ + 16 + 220), (int)(this.f_97736_ + 179 + 10), (int)0, (int)0x77000000);
        UIRenderHelper.swapAndBlitColor(UIRenderHelper.framebuffer, this.f_96541_.m_91385_());
    }

    public int renderScheduleEntry(PoseStack matrixStack, ScheduleEntry entry, int yOffset, int mouseX, int mouseY, float partialTicks) {
        int zLevel = -100;
        AllGuiTextures light = AllGuiTextures.SCHEDULE_CARD_LIGHT;
        AllGuiTextures medium = AllGuiTextures.SCHEDULE_CARD_MEDIUM;
        AllGuiTextures dark = AllGuiTextures.SCHEDULE_CARD_DARK;
        int cardWidth = 195;
        int cardHeader = 22;
        int maxRows = 0;
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            maxRows = Math.max(maxRows, list.size());
        }
        boolean supportsConditions = entry.instruction.supportsConditions();
        int cardHeight = cardHeader + (supportsConditions ? 24 + maxRows * 18 : 4);
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(this.f_97735_ + 25), (float)(this.f_97736_ + yOffset), 0.0f);
        UIRenderHelper.drawStretched(matrixStack, 0, 1, cardWidth, cardHeight - 2, zLevel, light);
        UIRenderHelper.drawStretched(matrixStack, 1, 0, cardWidth - 2, cardHeight, zLevel, light);
        UIRenderHelper.drawStretched(matrixStack, 1, 1, cardWidth - 2, cardHeight - 2, zLevel, dark);
        UIRenderHelper.drawStretched(matrixStack, 2, 2, cardWidth - 4, cardHeight - 4, zLevel, medium);
        UIRenderHelper.drawStretched(matrixStack, 2, 2, cardWidth - 4, cardHeader, zLevel, supportsConditions ? light : medium);
        AllGuiTextures.SCHEDULE_CARD_REMOVE.render(matrixStack, cardWidth - 14, 2);
        AllGuiTextures.SCHEDULE_CARD_DUPLICATE.render(matrixStack, cardWidth - 14, cardHeight - 14);
        int i = this.schedule.entries.indexOf(entry);
        if (i > 0) {
            AllGuiTextures.SCHEDULE_CARD_MOVE_UP.render(matrixStack, cardWidth, cardHeader - 14);
        }
        if (i < this.schedule.entries.size() - 1) {
            AllGuiTextures.SCHEDULE_CARD_MOVE_DOWN.render(matrixStack, cardWidth, cardHeader);
        }
        UIRenderHelper.drawStretched(matrixStack, 8, 0, 3, cardHeight + 10, zLevel, AllGuiTextures.SCHEDULE_STRIP_LIGHT);
        (supportsConditions ? AllGuiTextures.SCHEDULE_STRIP_TRAVEL : AllGuiTextures.SCHEDULE_STRIP_ACTION).render(matrixStack, 4, 6);
        if (supportsConditions) {
            AllGuiTextures.SCHEDULE_STRIP_WAIT.render(matrixStack, 4, 28);
        }
        Pair<ItemStack, Component> destination = entry.instruction.getSummary();
        this.renderInput(matrixStack, destination, 26, 5, false, 100);
        entry.instruction.renderSpecialIcon(matrixStack, 30, 5);
        matrixStack.m_85849_();
        return cardHeight;
    }

    public void renderScheduleConditions(PoseStack matrixStack, ScheduleEntry entry, int yOffset, int mouseX, int mouseY, float partialTicks, int cardHeight, int entryIndex) {
        int cardWidth = 195;
        int cardHeader = 22;
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(this.f_97735_ + 25), (float)(this.f_97736_ + yOffset), 0.0f);
        int xOffset = 26;
        float scrollOffset = this.getConditionScroll(entry, partialTicks, entryIndex);
        matrixStack.m_85836_();
        matrixStack.m_252880_(-scrollOffset, 0.0f, 0.0f);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = this.getConditionColumnWidth(list);
            for (int i = 0; i < list.size(); ++i) {
                ScheduleWaitCondition scheduleWaitCondition = list.get(i);
                Math.max(maxWidth, this.renderInput(matrixStack, scheduleWaitCondition.getSummary(), xOffset, 29 + i * 18, i != 0, maxWidth));
                scheduleWaitCondition.renderSpecialIcon(matrixStack, xOffset + 4, 29 + i * 18);
            }
            AllGuiTextures.SCHEDULE_CONDITION_APPEND.render(matrixStack, xOffset + (maxWidth - 10) / 2, 29 + list.size() * 18);
            xOffset += maxWidth + 10;
        }
        AllGuiTextures.SCHEDULE_CONDITION_NEW.render(matrixStack, xOffset - 3, 29);
        matrixStack.m_85849_();
        if (xOffset + 16 > cardWidth - 26) {
            TransformStack.cast((PoseStack)matrixStack).rotateZ(-90.0);
            Matrix4f m = matrixStack.m_85850_().m_252922_();
            ScreenUtils.drawGradientRect((Matrix4f)m, (int)200, (int)(-cardHeight + 2), (int)18, (int)(-2 - cardHeader), (int)28, (int)0x44000000, (int)0);
            ScreenUtils.drawGradientRect((Matrix4f)m, (int)200, (int)(-cardHeight + 2), (int)(cardWidth - 26), (int)(-2 - cardHeader), (int)(cardWidth - 16), (int)0, (int)0x44000000);
        }
        matrixStack.m_85849_();
    }

    private boolean isConditionAreaScrollable(ScheduleEntry entry) {
        int xOffset = 26;
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            xOffset += this.getConditionColumnWidth(list) + 10;
        }
        return xOffset + 16 > 169;
    }

    private float getConditionScroll(ScheduleEntry entry, float partialTicks, int entryIndex) {
        float scrollOffset = 0.0f;
        float scrollIndex = this.horizontalScrolls.get(entryIndex).getValue(partialTicks);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = this.getConditionColumnWidth(list);
            float partialOfThisColumn = Math.min(1.0f, scrollIndex);
            scrollOffset += (float)(maxWidth + 10) * partialOfThisColumn;
            scrollIndex -= partialOfThisColumn;
        }
        return scrollOffset;
    }

    private int getConditionColumnWidth(List<ScheduleWaitCondition> list) {
        int maxWidth = 0;
        for (ScheduleWaitCondition scheduleWaitCondition : list) {
            maxWidth = Math.max(maxWidth, this.getFieldSize(32, scheduleWaitCondition.getSummary()));
        }
        return maxWidth;
    }

    protected int renderInput(PoseStack matrixStack, Pair<ItemStack, Component> pair, int x, int y, boolean clean, int minSize) {
        ItemStack stack = pair.getFirst();
        Component text = pair.getSecond();
        boolean hasItem = !stack.m_41619_();
        int fieldSize = Math.min(this.getFieldSize(minSize, pair), 150);
        matrixStack.m_85836_();
        AllGuiTextures left = clean ? AllGuiTextures.SCHEDULE_CONDITION_LEFT_CLEAN : AllGuiTextures.SCHEDULE_CONDITION_LEFT;
        AllGuiTextures middle = AllGuiTextures.SCHEDULE_CONDITION_MIDDLE;
        AllGuiTextures item = AllGuiTextures.SCHEDULE_CONDITION_ITEM;
        AllGuiTextures right = AllGuiTextures.SCHEDULE_CONDITION_RIGHT;
        matrixStack.m_252880_((float)x, (float)y, 0.0f);
        UIRenderHelper.drawStretched(matrixStack, 0, 0, fieldSize, 16, -100, middle);
        left.render(matrixStack, clean ? 0 : -3, 0);
        right.render(matrixStack, fieldSize - 2, 0);
        if (hasItem) {
            item.render(matrixStack, 3, 0);
        }
        if (hasItem) {
            item.render(matrixStack, 3, 0);
            if (stack.m_41720_() != Items.f_42263_) {
                ((RenderElement)GuiGameElement.of(stack).at(4.0f, 0.0f)).render(matrixStack);
            }
        }
        if (text != null) {
            this.f_96547_.m_92750_(matrixStack, this.f_96547_.m_92854_((FormattedText)text, 120).getString(), hasItem ? 28.0f : 8.0f, 4.0f, -855314);
        }
        matrixStack.m_85849_();
        return fieldSize;
    }

    public boolean action(PoseStack ms, double mouseX, double mouseY, int click) {
        if (this.editingCondition != null || this.editingDestination != null) {
            return false;
        }
        Component empty = Components.immutableEmpty();
        int mx = (int)mouseX;
        int my = (int)mouseY;
        int x = mx - this.f_97735_ - 25;
        int y = my - this.f_97736_ - 25;
        if (x < 0 || x >= 205) {
            return false;
        }
        if (y < 0 || y >= 173) {
            return false;
        }
        y = (int)((float)y + this.scroll.getValue(0.0f));
        List<ScheduleEntry> entries = this.schedule.entries;
        for (int i = 0; i < entries.size(); ++i) {
            int center;
            ScheduleEntry entry = entries.get(i);
            int maxRows = 0;
            for (List<ScheduleWaitCondition> list : entry.conditions) {
                maxRows = Math.max(maxRows, list.size());
            }
            int cardHeight = 22 + (entry.instruction.supportsConditions() ? 24 + maxRows * 18 : 4);
            if (y >= cardHeight + 5) {
                if ((y -= cardHeight + 10) >= 0) continue;
                return false;
            }
            int fieldSize = this.getFieldSize(100, entry.instruction.getSummary());
            if (x > 25 && x <= 25 + fieldSize && y > 4 && y <= 20) {
                ArrayList<Component> components = new ArrayList<Component>();
                components.addAll(entry.instruction.getTitleAs("instruction"));
                components.add(empty);
                components.add(this.clickToEdit);
                this.m_169388_(ms, components, Optional.empty(), mx, my);
                if (click == 0) {
                    this.startEditing(entry.instruction, confirmed -> {
                        if (confirmed.booleanValue()) {
                            entry.instruction = this.editingDestination;
                        }
                    }, false);
                }
                return true;
            }
            if (x > 180 && x <= 192) {
                if (y > 0 && y <= 14) {
                    this.m_169388_(ms, (List)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.remove_entry", new Object[0])), Optional.empty(), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        this.m_7856_();
                    }
                    return true;
                }
                if (y > cardHeight - 14) {
                    this.m_169388_(ms, (List)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.duplicate", new Object[0])), Optional.empty(), mx, my);
                    if (click == 0) {
                        entries.add(entries.indexOf(entry), entry.clone());
                        this.m_7856_();
                    }
                    return true;
                }
            }
            if (x > 194) {
                if (y > 7 && y <= 20 && i > 0) {
                    this.m_169388_(ms, (List)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.move_up", new Object[0])), Optional.empty(), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i - 1, entry);
                        this.m_7856_();
                    }
                    return true;
                }
                if (y > 20 && y <= 33 && i < entries.size() - 1) {
                    this.m_169388_(ms, (List)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.move_down", new Object[0])), Optional.empty(), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i + 1, entry);
                        this.m_7856_();
                    }
                    return true;
                }
            }
            if (y > (center = (cardHeight - 8 + 22) / 2) - 1 && y <= center + 7 && this.isConditionAreaScrollable(entry)) {
                float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
                if (x > 12 && x <= 19 && !Mth.m_14033_((float)chaseTarget, (float)0.0f)) {
                    if (click == 0) {
                        this.horizontalScrolls.get(i).chase(chaseTarget - 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    }
                    return true;
                }
                if (x > 177 && x <= 184 && !Mth.m_14033_((float)chaseTarget, (float)(entry.conditions.size() - 1))) {
                    if (click == 0) {
                        this.horizontalScrolls.get(i).chase(chaseTarget + 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    }
                    return true;
                }
            }
            if ((x -= 18) < 0 || (y -= 28) < 0 || x > 160) {
                return false;
            }
            x = (int)((float)x + (this.getConditionScroll(entry, 0.0f, i) - 8.0f));
            List<List<ScheduleWaitCondition>> columns = entry.conditions;
            for (int j = 0; j < columns.size(); ++j) {
                List<ScheduleWaitCondition> conditions = columns.get(j);
                if (x < 0) {
                    return false;
                }
                int w = this.getConditionColumnWidth(conditions);
                if (x >= w) {
                    x -= w + 10;
                    continue;
                }
                int row = y / 18;
                if (row < conditions.size() && row >= 0) {
                    boolean canRemove = conditions.size() > 1 || columns.size() > 1;
                    ArrayList<Object> components = new ArrayList<Object>();
                    components.add(Lang.translateDirect("schedule.condition_type", new Object[0]).m_130940_(ChatFormatting.GRAY));
                    ScheduleWaitCondition condition = conditions.get(row);
                    components.addAll(condition.getTitleAs("condition"));
                    components.add(empty);
                    components.add(this.clickToEdit);
                    if (canRemove) {
                        components.add(this.rClickToDelete);
                    }
                    this.m_169388_(ms, components, Optional.empty(), mx, my);
                    if (canRemove && click == 1) {
                        conditions.remove(row);
                        if (conditions.isEmpty()) {
                            columns.remove(conditions);
                        }
                    }
                    if (click == 0) {
                        this.startEditing(condition, confirmed -> {
                            conditions.remove(row);
                            if (confirmed.booleanValue()) {
                                conditions.add(row, this.editingCondition);
                                return;
                            }
                            if (conditions.isEmpty()) {
                                columns.remove(conditions);
                            }
                        }, canRemove);
                    }
                    return true;
                }
                if (y > 18 * conditions.size() && y <= 18 * conditions.size() + 10 && x >= w / 2 - 5 && x < w / 2 + 5) {
                    this.m_169388_(ms, (List)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.add_condition", new Object[0])), Optional.empty(), mx, my);
                    if (click == 0) {
                        this.startEditing(new ScheduledDelay(), confirmed -> {
                            if (confirmed.booleanValue()) {
                                conditions.add(this.editingCondition);
                            }
                        }, true);
                    }
                    return true;
                }
                return false;
            }
            if (x < 0 || x > 15 || y > 20) {
                return false;
            }
            this.m_169388_(ms, (List)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.alternative_condition", new Object[0])), Optional.empty(), mx, my);
            if (click == 0) {
                this.startEditing(new ScheduledDelay(), confirmed -> {
                    if (!confirmed.booleanValue()) {
                        return;
                    }
                    ArrayList<ScheduleWaitCondition> conditions = new ArrayList<ScheduleWaitCondition>();
                    conditions.add(this.editingCondition);
                    columns.add(conditions);
                }, true);
            }
            return true;
        }
        if (x < 18 || x > 33 || y > 14) {
            return false;
        }
        this.m_169388_(ms, (List)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.add_entry", new Object[0])), Optional.empty(), mx, my);
        if (click == 0) {
            this.startEditing(new DestinationInstruction(), confirmed -> {
                if (!confirmed.booleanValue()) {
                    return;
                }
                ScheduleEntry entry = new ScheduleEntry();
                ScheduledDelay delay = new ScheduledDelay();
                ArrayList<ScheduledDelay> initialConditions = new ArrayList<ScheduledDelay>();
                initialConditions.add(delay);
                entry.instruction = this.editingDestination;
                entry.conditions.add(initialConditions);
                this.schedule.entries.add(entry);
            }, true);
        }
        return true;
    }

    private int getFieldSize(int minSize, Pair<ItemStack, Component> pair) {
        ItemStack stack = pair.getFirst();
        Component text = pair.getSecond();
        boolean hasItem = !stack.m_41619_();
        return Math.max((text == null ? 0 : this.f_96547_.m_92852_((FormattedText)text)) + (hasItem ? 20 : 0) + 16, minSize);
    }

    protected void startStencil(PoseStack matrixStack, float x, float y, float w, float h) {
        RenderSystem.m_69421_((int)1280, (boolean)Minecraft.f_91002_);
        GL11.glDisable((int)2960);
        RenderSystem.m_69929_((int)-1);
        RenderSystem.m_69421_((int)1024, (boolean)Minecraft.f_91002_);
        GL11.glEnable((int)2960);
        RenderSystem.m_69931_((int)7681, (int)7680, (int)7680);
        RenderSystem.m_69929_((int)255);
        RenderSystem.m_69925_((int)512, (int)1, (int)255);
        matrixStack.m_85836_();
        matrixStack.m_252880_(x, y, 0.0f);
        matrixStack.m_85841_(w, h, 1.0f);
        ScreenUtils.drawGradientRect((Matrix4f)matrixStack.m_85850_().m_252922_(), (int)-100, (int)0, (int)0, (int)1, (int)1, (int)-16777216, (int)-16777216);
        matrixStack.m_85849_();
        GL11.glEnable((int)2960);
        RenderSystem.m_69931_((int)7680, (int)7680, (int)7680);
        RenderSystem.m_69925_((int)514, (int)1, (int)255);
    }

    protected void endStencil() {
        GL11.glDisable((int)2960);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.m_93884_((int)pMouseX, (int)pMouseY, pButton)) {
            return true;
        }
        if (this.editorConfirm != null && this.editorConfirm.m_5953_(pMouseX, pMouseY) && this.onEditorClose != null) {
            this.onEditorClose.accept(true);
            this.stopEditing();
            return true;
        }
        if (this.editorDelete != null && this.editorDelete.m_5953_(pMouseX, pMouseY) && this.onEditorClose != null) {
            this.onEditorClose.accept(false);
            this.stopEditing();
            return true;
        }
        if (this.action(new PoseStack(), pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitE;
        if (this.destinationSuggestions != null && this.destinationSuggestions.m_93888_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.editingCondition == null && this.editingDestination == null) {
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        boolean hitEnter = this.m_7222_() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        boolean bl = hitE = this.m_7222_() == null && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey);
        if (hitE || hitEnter) {
            this.onEditorClose.accept(true);
            this.stopEditing();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int maxRows;
        if (this.destinationSuggestions != null && this.destinationSuggestions.m_93882_(Mth.m_14008_((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        if (this.editingCondition != null || this.editingDestination != null) {
            return super.m_6050_(pMouseX, pMouseY, pDelta);
        }
        if (ScheduleScreen.m_96638_()) {
            List<ScheduleEntry> entries = this.schedule.entries;
            int y = (int)(pMouseY - (double)this.f_97736_ - 25.0 + (double)this.scroll.getValue());
            for (int i = 0; i < entries.size(); ++i) {
                ScheduleEntry entry = entries.get(i);
                maxRows = 0;
                for (List<ScheduleWaitCondition> list : entry.conditions) {
                    maxRows = Math.max(maxRows, list.size());
                }
                int cardHeight = 46 + maxRows * 18;
                if (y >= cardHeight) {
                    if ((y -= cardHeight + 9) >= 0) continue;
                    break;
                }
                if (!this.isConditionAreaScrollable(entry) || y < 24 || pMouseX < (double)(this.f_97735_ + 25) || pMouseX > (double)(this.f_97735_ + 205)) break;
                float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
                if (pDelta > 0.0 && !Mth.m_14033_((float)chaseTarget, (float)0.0f)) {
                    this.horizontalScrolls.get(i).chase(chaseTarget - 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    return true;
                }
                if (pDelta < 0.0 && !Mth.m_14033_((float)chaseTarget, (float)(entry.conditions.size() - 1))) {
                    this.horizontalScrolls.get(i).chase(chaseTarget + 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    return true;
                }
                return false;
            }
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -133.0f;
        for (ScheduleEntry scheduleEntry : this.schedule.entries) {
            maxRows = 0;
            for (List<ScheduleWaitCondition> list : scheduleEntry.conditions) {
                maxRows = Math.max(maxRows, list.size());
            }
            max += (float)(46 + maxRows * 18 + 10);
        }
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((int)chaseTarget, 0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, 0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    @Override
    protected void renderForeground(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.destinationSuggestions != null) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 0.0f, 500.0f);
            this.destinationSuggestions.m_93900_(matrixStack, mouseX, mouseY);
            matrixStack.m_85849_();
        }
        super.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((ScheduleContainer)this.f_97732_).contentHolder).at(this.f_97735_ + AllGuiTextures.SCHEDULE.width, this.f_97736_ + AllGuiTextures.SCHEDULE.height - 56, -200.0f)).scale(3.0).render(matrixStack);
        this.action(matrixStack, mouseX, mouseY, -1);
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        int x = this.f_97735_ + 53;
        int y = this.f_97736_ + 87;
        if (mouseX < x || mouseY < y || mouseX >= x + 120 || mouseY >= y + 18) {
            return;
        }
        ScheduleDataEntry rendered = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        for (int i = 0; i < Math.max(1, rendered.slotsTargeted()); ++i) {
            List<Component> secondLineTooltip = rendered.getSecondLineTooltip(i);
            if (secondLineTooltip == null || this.f_97734_ != ((ScheduleContainer)this.f_97732_).m_38853_(36 + i) || !this.f_97734_.m_7993_().m_41619_()) continue;
            this.m_169388_(matrixStack, secondLineTooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        AllGuiTextures.SCHEDULE.render(pPoseStack, this.f_97735_, this.f_97736_);
        FormattedCharSequence formattedcharsequence = this.f_96539_.m_7532_();
        int center = this.f_97735_ + (AllGuiTextures.SCHEDULE.width - 8) / 2;
        this.f_96547_.m_92877_(pPoseStack, formattedcharsequence, (float)(center - this.f_96547_.m_92724_(formattedcharsequence) / 2), (float)this.f_97736_ + 4.0f, 0x505050);
        this.renderSchedule(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        this.m_93179_(pPoseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        AllGuiTextures.SCHEDULE_EDITOR.render(pPoseStack, this.f_97735_ - 2, this.f_97736_ + 40);
        AllGuiTextures.PLAYER_INVENTORY.render(pPoseStack, this.f_97735_ + 38, this.f_97736_ + 122);
        this.f_96547_.m_92889_(pPoseStack, this.f_169604_, (float)(this.f_97735_ + 46), (float)(this.f_97736_ + 128), 0x505050);
        formattedcharsequence = this.editingCondition == null ? Lang.translateDirect("schedule.instruction.editor", new Object[0]).m_7532_() : Lang.translateDirect("schedule.condition.editor", new Object[0]).m_7532_();
        this.f_96547_.m_92877_(pPoseStack, formattedcharsequence, (float)(center - this.f_96547_.m_92724_(formattedcharsequence) / 2), (float)this.f_97736_ + 44.0f, 0x505050);
        ScheduleDataEntry rendered = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        for (int i = 0; i < rendered.slotsTargeted(); ++i) {
            AllGuiTextures.SCHEDULE_EDITOR_ADDITIONAL_SLOT.render(pPoseStack, this.f_97735_ + 53 + 20 * i, this.f_97736_ + 87);
        }
        if (rendered.slotsTargeted() == 0 && !rendered.renderSpecialIcon(pPoseStack, this.f_97735_ + 54, this.f_97736_ + 88)) {
            Pair<ItemStack, Component> summary = rendered.getSummary();
            ItemStack icon = summary.getFirst();
            if (icon.m_41619_()) {
                icon = rendered.getSecondLineIcon();
            }
            if (icon.m_41619_()) {
                AllGuiTextures.SCHEDULE_EDITOR_INACTIVE_SLOT.render(pPoseStack, this.f_97735_ + 53, this.f_97736_ + 87);
            } else {
                ((RenderElement)GuiGameElement.of(icon).at(this.f_97735_ + 54, this.f_97736_ + 88)).render(pPoseStack);
            }
        }
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(0.0f, (float)(this.getGuiTop() + 87), 0.0f);
        this.editorSubWidgets.renderWidgetBG(this.getGuiLeft() + 77, pPoseStack);
        pPoseStack.m_85849_();
    }

    public void m_7861_() {
        super.m_7861_();
        AllPackets.channel.sendToServer((Object)new ScheduleEditPacket(this.schedule));
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    public Font getFont() {
        return this.f_96547_;
    }
}

