/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.track;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TrackRenderer
extends SafeTileEntityRenderer<TrackTileEntity> {
    public TrackRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(TrackTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Level level = te.m_58904_();
        if (Backend.canUseInstancing((Level)level)) {
            return;
        }
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110457_());
        te.connections.values().forEach(bc -> TrackRenderer.renderBezierTurn(level, bc, ms, vb));
    }

    public static void renderBezierTurn(Level level, BezierConnection bc, PoseStack ms, VertexConsumer vb) {
        if (!bc.isPrimary()) {
            return;
        }
        ms.m_85836_();
        BlockPos tePosition = (BlockPos)bc.tePositions.getFirst();
        BlockState air = Blocks.f_50016_.m_49966_();
        BezierConnection.SegmentAngles[] segments = bc.getBakedSegments();
        TransformStack.cast((PoseStack)ms).nudge((int)tePosition.m_121878_());
        TrackRenderer.renderGirder(level, bc, ms, vb, tePosition);
        for (int i = 1; i < segments.length; ++i) {
            BezierConnection.SegmentAngles segment = segments[i];
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)segment.lightPosition.m_121955_((Vec3i)tePosition));
            CachedBufferer.partial(AllBlockPartials.TRACK_TIE, air).mulPose(segment.tieTransform.m_252922_()).mulNormal(segment.tieTransform.m_252943_()).light(light).renderInto(ms, vb);
            for (boolean first : Iterate.trueAndFalse) {
                PoseStack.Pose transform = segment.railTransforms.get(first);
                CachedBufferer.partial(first ? AllBlockPartials.TRACK_SEGMENT_LEFT : AllBlockPartials.TRACK_SEGMENT_RIGHT, air).mulPose(transform.m_252922_()).mulNormal(transform.m_252943_()).light(light).renderInto(ms, vb);
            }
        }
        ms.m_85849_();
    }

    private static void renderGirder(Level level, BezierConnection bc, PoseStack ms, VertexConsumer vb, BlockPos tePosition) {
        if (!bc.hasGirder) {
            return;
        }
        BlockState air = Blocks.f_50016_.m_49966_();
        BezierConnection.GirderAngles[] girders = bc.getBakedGirders();
        for (int i = 1; i < girders.length; ++i) {
            BezierConnection.GirderAngles segment = girders[i];
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)segment.lightPosition.m_121955_((Vec3i)tePosition));
            for (boolean first : Iterate.trueAndFalse) {
                PoseStack.Pose beamTransform = segment.beams.get(first);
                CachedBufferer.partial(AllBlockPartials.GIRDER_SEGMENT_MIDDLE, air).mulPose(beamTransform.m_252922_()).mulNormal(beamTransform.m_252943_()).light(light).renderInto(ms, vb);
                for (boolean top : Iterate.trueAndFalse) {
                    PoseStack.Pose beamCapTransform = segment.beamCaps.get(top).get(first);
                    CachedBufferer.partial(top ? AllBlockPartials.GIRDER_SEGMENT_TOP : AllBlockPartials.GIRDER_SEGMENT_BOTTOM, air).mulPose(beamCapTransform.m_252922_()).mulNormal(beamCapTransform.m_252943_()).light(light).renderInto(ms, vb);
                }
            }
        }
    }

    public static Vec3 getModelAngles(Vec3 normal, Vec3 diff) {
        double diffX = diff.m_7096_();
        double diffY = diff.m_7098_();
        double diffZ = diff.m_7094_();
        double len = Mth.m_14116_((float)((float)(diffX * diffX + diffZ * diffZ)));
        double yaw = Mth.m_14136_((double)diffX, (double)diffZ);
        double pitch = Mth.m_14136_((double)len, (double)diffY) - 1.5707963267948966;
        Vec3 yawPitchNormal = VecHelper.rotate(VecHelper.rotate(new Vec3(0.0, 1.0, 0.0), AngleHelper.deg(pitch), Direction.Axis.X), AngleHelper.deg(yaw), Direction.Axis.Y);
        double signum = Math.signum(yawPitchNormal.m_82526_(normal));
        if (Math.abs(signum) < 0.5) {
            signum = yawPitchNormal.m_82557_(normal) < 0.5 ? -1.0 : 1.0;
        }
        double dot = diff.m_82537_(normal).m_82541_().m_82526_(yawPitchNormal);
        double roll = Math.acos(Mth.m_14008_((double)dot, (double)-1.0, (double)1.0)) * signum;
        return new Vec3(pitch, yaw, roll);
    }

    public boolean shouldRenderOffScreen(TrackTileEntity pBlockEntity) {
        return true;
    }

    public int m_142163_() {
        return 192;
    }
}

