/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.client.tools.Tools;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ToolSelectionScreen
extends Screen {
    public final String scrollToCycle = Lang.translateDirect("gui.toolmenu.cycle", new Object[0]).getString();
    public final String holdToFocus = "gui.toolmenu.focusKey";
    protected List<Tools> tools;
    protected Consumer<Tools> callback;
    public boolean f_94673_;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;

    public ToolSelectionScreen(List<Tools> tools, Consumer<Tools> callback) {
        super((Component)Components.literal("Tool Selection"));
        this.f_96541_ = Minecraft.m_91087_();
        this.tools = tools;
        this.callback = callback;
        this.f_94673_ = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        callback.accept(tools.get(this.selection));
        this.w = Math.max(tools.size() * 50 + 30, 220);
        this.h = 30;
    }

    public void setSelectedElement(Tools tool) {
        if (!this.tools.contains((Object)tool)) {
            return;
        }
        this.selection = this.tools.indexOf((Object)tool);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(PoseStack matrixStack, float partialTicks) {
        Window mainWindow = this.f_96541_.m_91268_();
        if (!this.initialized) {
            this.m_6575_(this.f_96541_, mainWindow.m_85445_(), mainWindow.m_85446_());
        }
        int x = (mainWindow.m_85445_() - this.w) / 2 + 15;
        int y = mainWindow.m_85446_() - this.h - 75;
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, -this.yOffset, this.f_94673_ ? 100.0f : 0.0f);
        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.f_94673_ ? 0.875f : 0.5f));
        RenderSystem.m_157456_((int)0, (ResourceLocation)gray.location);
        ToolSelectionScreen.m_93133_((PoseStack)matrixStack, (int)(x - 15), (int)y, (float)gray.startX, (float)gray.startY, (int)this.w, (int)this.h, (int)gray.width, (int)gray.height);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<Component> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            ToolSelectionScreen.m_93133_((PoseStack)matrixStack, (int)(x - 15), (int)(y + 33), (float)gray.startX, (float)gray.startY, (int)this.w, (int)(this.h + 22), (int)gray.width, (int)gray.height);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                this.f_96547_.m_92889_(matrixStack, toolTip.get(0), (float)(x - 10), (float)(y + 38), 0xEEEEEE + stringAlphaComponent);
            }
            if (toolTip.size() > 1) {
                this.f_96547_.m_92889_(matrixStack, toolTip.get(1), (float)(x - 10), (float)(y + 50), 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 2) {
                this.f_96547_.m_92889_(matrixStack, toolTip.get(2), (float)(x - 10), (float)(y + 60), 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 3) {
                this.f_96547_.m_92889_(matrixStack, toolTip.get(3), (float)(x - 10), (float)(y + 72), 0xCCCCDD + stringAlphaComponent);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.getBoundKey();
            int width = this.f_96541_.m_91268_().m_85445_();
            if (!this.f_94673_) {
                ToolSelectionScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (Component)Lang.translateDirect("gui.toolmenu.focusKey", keyName), (int)(width / 2), (int)(y - 10), (int)0xCCDDFF);
            } else {
                ToolSelectionScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)this.scrollToCycle, (int)(width / 2), (int)(y - 10), (int)0xCCDDFF);
            }
        } else {
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            matrixStack.m_85836_();
            float f = alpha = this.f_94673_ ? 1.0f : 0.2f;
            if (i == this.selection) {
                matrixStack.m_252880_(0.0f, -10.0f, 0.0f);
                ToolSelectionScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)this.tools.get(i).getDisplayName().getString(), (int)(x + i * 50 + 24), (int)(y + 28), (int)0xCCDDFF);
                alpha = 1.0f;
            }
            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().render(matrixStack, x + i * 50 + 16, y + 12, (GuiComponent)this);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().render(matrixStack, x + i * 50 + 16, y + 11, (GuiComponent)this);
            matrixStack.m_85849_();
        }
        RenderSystem.m_69461_();
        matrixStack.m_85849_();
    }

    public void update() {
        this.yOffset = this.f_94673_ ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(PoseStack matrixStack, float partialTicks) {
        this.draw(matrixStack, partialTicks);
    }

    public void m_7379_() {
        this.callback.accept(this.tools.get(this.selection));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initialized = true;
    }
}

