/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraftforge.common.util.LazyOptional;

public class CouplingCommand {
    public static final SimpleCommandExceptionType ONLY_MINECARTS_ALLOWED = new SimpleCommandExceptionType((Message)Components.literal("Only Minecarts can be coupled"));
    public static final SimpleCommandExceptionType SAME_DIMENSION = new SimpleCommandExceptionType((Message)Components.literal("Minecarts have to be in the same Dimension"));
    public static final DynamicCommandExceptionType TWO_CARTS = new DynamicCommandExceptionType(a -> Components.literal("Your selector targeted " + a + " entities. You can only couple 2 Minecarts at a time."));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"coupling").requires(cs -> cs.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"cart1", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"cart2", (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> {
            Entity cart1 = EntityArgument.m_91452_((CommandContext)ctx, (String)"cart1");
            if (!(cart1 instanceof AbstractMinecart)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            Entity cart2 = EntityArgument.m_91452_((CommandContext)ctx, (String)"cart2");
            if (!(cart2 instanceof AbstractMinecart)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            if (!cart1.m_20193_().equals(cart2.m_20193_())) {
                throw SAME_DIMENSION.create();
            }
            Entity source = ((CommandSourceStack)ctx.getSource()).m_81373_();
            CouplingHandler.tryToCoupleCarts(source instanceof Player ? (Player)source : null, cart1.m_20193_(), cart1.m_19879_(), cart2.m_19879_());
            return 1;
        })))).then(Commands.m_82129_((String)"carts", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> {
            Collection entities = EntityArgument.m_91461_((CommandContext)ctx, (String)"carts");
            if (entities.size() != 2) {
                throw TWO_CARTS.create((Object)entities.size());
            }
            ArrayList eList = Lists.newArrayList((Iterable)entities);
            Entity cart1 = (Entity)eList.get(0);
            if (!(cart1 instanceof AbstractMinecart)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            Entity cart2 = (Entity)eList.get(1);
            if (!(cart2 instanceof AbstractMinecart)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            if (!cart1.m_20193_().equals(cart2.m_20193_())) {
                throw SAME_DIMENSION.create();
            }
            Entity source = ((CommandSourceStack)ctx.getSource()).m_81373_();
            CouplingHandler.tryToCoupleCarts(source instanceof Player ? (Player)source : null, cart1.m_20193_(), cart1.m_19879_(), cart2.m_19879_());
            return 1;
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"cart1", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"cart2", (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> {
            Entity cart1 = EntityArgument.m_91452_((CommandContext)ctx, (String)"cart1");
            if (!(cart1 instanceof AbstractMinecart)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            Entity cart2 = EntityArgument.m_91452_((CommandContext)ctx, (String)"cart2");
            if (!(cart2 instanceof AbstractMinecart)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            LazyOptional cart1Capability = cart1.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
            if (!cart1Capability.isPresent()) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Components.literal("Minecart has no Couplings Attached"), true);
                return 0;
            }
            MinecartController cart1Controller = (MinecartController)cart1Capability.orElse(null);
            int cart1Couplings = (cart1Controller.isConnectedToCoupling() ? 1 : 0) + (cart1Controller.isLeadingCoupling() ? 1 : 0);
            if (cart1Couplings == 0) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Components.literal("Minecart has no Couplings Attached"), true);
                return 0;
            }
            for (boolean bool : Iterate.trueAndFalse) {
                UUID coupledCart = cart1Controller.getCoupledCart(bool);
                if (coupledCart == null || coupledCart != cart2.m_20148_()) continue;
                MinecartController cart2Controller = CapabilityMinecartController.getIfPresent(cart1.m_20193_(), coupledCart);
                if (cart2Controller == null) {
                    return 0;
                }
                cart1Controller.removeConnection(bool);
                cart2Controller.removeConnection(!bool);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Components.literal("The specified Carts are not coupled"), true);
            return 0;
        }))))).then(Commands.m_82127_((String)"removeAll").then(Commands.m_82129_((String)"cart", (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> {
            Entity cart = EntityArgument.m_91452_((CommandContext)ctx, (String)"cart");
            if (!(cart instanceof AbstractMinecart)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            LazyOptional capability = cart.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
            if (!capability.isPresent()) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Components.literal("Minecart has no Couplings Attached"), true);
                return 0;
            }
            MinecartController controller = (MinecartController)capability.orElse(null);
            int couplings = (controller.isConnectedToCoupling() ? 1 : 0) + (controller.isLeadingCoupling() ? 1 : 0);
            if (couplings == 0) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Components.literal("Minecart has no Couplings Attached"), true);
                return 0;
            }
            controller.decouple();
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Components.literal("Removed " + couplings + " couplings from the Minecart"), true);
            return couplings;
        })));
    }
}

