/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.foundation.utility.Components;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableInt;

public class ReplaceInCommandBlocksCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"replaceInCommandBlocks").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"begin", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"end", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"toReplace", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"replaceWith", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ReplaceInCommandBlocksCommand.doReplace((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"begin"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"end"), StringArgumentType.getString((CommandContext)ctx, (String)"toReplace"), StringArgumentType.getString((CommandContext)ctx, (String)"replaceWith"));
            return 1;
        })))));
    }

    private static void doReplace(CommandSourceStack source, BlockPos from, BlockPos to, String toReplace, String replaceWith) {
        ServerLevel world = source.m_81372_();
        MutableInt blocks = new MutableInt(0);
        BlockPos.m_121990_((BlockPos)from, (BlockPos)to).forEach(pos -> {
            BlockState blockState = world.m_8055_(pos);
            if (!(blockState.m_60734_() instanceof CommandBlock)) {
                return;
            }
            BlockEntity tileEntity = world.m_7702_(pos);
            if (!(tileEntity instanceof CommandBlockEntity)) {
                return;
            }
            CommandBlockEntity cb = (CommandBlockEntity)tileEntity;
            BaseCommandBlock commandBlockLogic = cb.m_59141_();
            String command = commandBlockLogic.m_45438_();
            if (command.indexOf(toReplace) != -1) {
                blocks.increment();
            }
            commandBlockLogic.m_6590_(command.replaceAll(toReplace, replaceWith));
            cb.m_6596_();
            world.m_7260_(pos, blockState, blockState, 2);
        });
        int intValue = blocks.intValue();
        if (intValue == 0) {
            source.m_81354_((Component)Components.literal("Couldn't find \"" + toReplace + "\" anywhere."), true);
            return;
        }
        source.m_81354_((Component)Components.literal("Replaced occurrences in " + intValue + " blocks."), true);
    }
}

