/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.container;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.TickableGuiEventListener;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public abstract class AbstractSimiContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected int windowXOffset;
    protected int windowYOffset;

    public AbstractSimiContainerScreen(T container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    protected void setWindowSize(int width, int height) {
        this.f_97726_ = width;
        this.f_97727_ = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ += this.windowXOffset;
        this.f_97736_ += this.windowYOffset;
    }

    protected void m_181908_() {
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof TickableGuiEventListener)) continue;
            TickableGuiEventListener tickable = (TickableGuiEventListener)listener;
            tickable.tick();
        }
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(W ... widgets) {
        for (W widget : widgets) {
            this.m_142416_((GuiEventListener)widget);
        }
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(Collection<W> widgets) {
        for (GuiEventListener widget : widgets) {
            this.m_142416_(widget);
        }
    }

    protected void removeWidgets(GuiEventListener ... widgets) {
        for (GuiEventListener widget : widgets) {
            this.m_169411_(widget);
        }
    }

    protected void removeWidgets(Collection<? extends GuiEventListener> widgets) {
        for (GuiEventListener guiEventListener : widgets) {
            this.m_169411_(guiEventListener);
        }
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.f_96541_.m_91296_();
        this.m_7333_(matrixStack);
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        this.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
    }

    protected void renderForeground(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7025_(ms, mouseX, mouseY);
        for (Renderable widget : this.f_169369_) {
            List<Component> tooltip;
            AbstractSimiWidget simiWidget;
            if (!(widget instanceof AbstractSimiWidget) || !(simiWidget = (AbstractSimiWidget)widget).m_198029_() || (tooltip = simiWidget.getToolTip()).isEmpty()) continue;
            int ttx = simiWidget.lockedTooltipX == -1 ? mouseX : simiWidget.lockedTooltipX + simiWidget.m_252754_();
            int tty = simiWidget.lockedTooltipY == -1 ? mouseY : simiWidget.lockedTooltipY + simiWidget.m_252907_();
            this.m_96597_(ms, tooltip, ttx, tty);
        }
    }

    public int getLeftOfCentered(int textureWidth) {
        return this.f_97735_ - this.windowXOffset + (this.f_97726_ - textureWidth) / 2;
    }

    public void renderPlayerInventory(PoseStack ms, int x, int y) {
        AllGuiTextures.PLAYER_INVENTORY.render(ms, x, y, (GuiComponent)this);
        this.f_96547_.m_92889_(ms, this.f_169604_, (float)(x + 8), (float)(y + 6), 0x404040);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (this.m_7222_() != null && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            return false;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public GuiEventListener m_7222_() {
        GuiEventListener focused = super.m_7222_();
        if (focused instanceof AbstractWidget && !((AbstractWidget)focused).m_93696_()) {
            focused = null;
        }
        this.m_7522_(focused);
        return focused;
    }

    public List<Rect2i> getExtraAreas() {
        return Collections.emptyList();
    }

    @Deprecated
    protected void debugWindowArea(PoseStack matrixStack) {
        AbstractSimiContainerScreen.m_93172_((PoseStack)matrixStack, (int)(this.f_97735_ + this.f_97726_), (int)(this.f_97736_ + this.f_97727_), (int)this.f_97735_, (int)this.f_97736_, (int)-741092397);
    }

    @Deprecated
    protected void debugExtraAreas(PoseStack matrixStack) {
        for (Rect2i area : this.getExtraAreas()) {
            AbstractSimiContainerScreen.m_93172_((PoseStack)matrixStack, (int)(area.m_110085_() + area.m_110090_()), (int)(area.m_110086_() + area.m_110091_()), (int)area.m_110085_(), (int)area.m_110086_(), (int)-741092397);
        }
    }
}

