/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.element.DelegatedStencilElement;
import com.simibubi.create.foundation.utility.Components;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TextStencilElement
extends DelegatedStencilElement {
    protected Font font;
    protected MutableComponent component;
    protected boolean centerVertically = false;
    protected boolean centerHorizontally = false;

    public TextStencilElement(Font font) {
        this.font = font;
        this.height = 10;
    }

    public TextStencilElement(Font font, String text) {
        this(font);
        this.component = Components.literal(text);
    }

    public TextStencilElement(Font font, MutableComponent component) {
        this(font);
        this.component = component;
    }

    public TextStencilElement withText(String text) {
        this.component = Components.literal(text);
        return this;
    }

    public TextStencilElement withText(MutableComponent component) {
        this.component = component;
        return this;
    }

    public TextStencilElement centered(boolean vertical, boolean horizontal) {
        this.centerVertically = vertical;
        this.centerHorizontally = horizontal;
        return this;
    }

    @Override
    protected void renderStencil(PoseStack ms) {
        float x = 0.0f;
        float y = 0.0f;
        if (this.centerHorizontally) {
            x = (float)this.width / 2.0f - (float)this.font.m_92852_((FormattedText)this.component) / 2.0f;
        }
        if (this.centerVertically) {
            float f = (float)this.height / 2.0f;
            Objects.requireNonNull(this.font);
            y = f - (float)(9 - 1) / 2.0f;
        }
        this.font.m_92889_(ms, (Component)this.component, x, y, -16777216);
    }

    @Override
    protected void renderElement(PoseStack ms) {
        float x = 0.0f;
        float y = 0.0f;
        if (this.centerHorizontally) {
            x = (float)this.width / 2.0f - (float)this.font.m_92852_((FormattedText)this.component) / 2.0f;
        }
        if (this.centerVertically) {
            float f = (float)this.height / 2.0f;
            Objects.requireNonNull(this.font);
            y = f - (float)(9 - 1) / 2.0f;
        }
        ms.m_85836_();
        ms.m_252880_(x, y, 0.0f);
        int n = this.font.m_92852_((FormattedText)this.component);
        Objects.requireNonNull(this.font);
        this.element.render(ms, n, 9 + 2, this.alpha);
        ms.m_85849_();
    }

    public MutableComponent getComponent() {
        return this.component;
    }
}

