/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item.render;

import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomRenderedItems {
    private final Map<ResourceLocation, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>> modelFuncs = new HashMap<ResourceLocation, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>>();
    private final Map<Item, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>> finalModelFuncs = new IdentityHashMap<Item, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>>();

    public void register(ResourceLocation item, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel> func) {
        this.modelFuncs.put(item, func);
    }

    public void forEach(NonNullBiConsumer<Item, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>> consumer) {
        this.loadEntriesIfMissing();
        this.finalModelFuncs.forEach((BiConsumer<Item, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>>)consumer);
    }

    private void loadEntriesIfMissing() {
        if (this.finalModelFuncs.isEmpty()) {
            this.loadEntries();
        }
    }

    private void loadEntries() {
        this.finalModelFuncs.clear();
        CustomRenderedItemModelRenderer.acceptModelFuncs((NonNullBiConsumer<Item, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>>)((NonNullBiConsumer)this.finalModelFuncs::put));
        this.modelFuncs.forEach((? super K location, ? super V func) -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (item == null) {
                return;
            }
            this.finalModelFuncs.put(item, (NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>)func);
        });
    }
}

