/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.ponder.PonderWorld;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;

public class PonderWorldParticles {
    private final Map<ParticleRenderType, Queue<Particle>> byType = Maps.newIdentityHashMap();
    private final Queue<Particle> queue = Queues.newArrayDeque();
    PonderWorld world;

    public PonderWorldParticles(PonderWorld world) {
        this.world = world;
    }

    public void addParticle(Particle p) {
        this.queue.add(p);
    }

    public void tick() {
        Particle particle;
        this.byType.forEach((p_228347_1_, p_228347_2_) -> this.tickParticleList((Collection<Particle>)p_228347_2_));
        if (this.queue.isEmpty()) {
            return;
        }
        while ((particle = this.queue.poll()) != null) {
            this.byType.computeIfAbsent(particle.m_7556_(), $ -> EvictingQueue.create((int)16384)).add(particle);
        }
    }

    private void tickParticleList(Collection<Particle> p_187240_1_) {
        if (p_187240_1_.isEmpty()) {
            return;
        }
        Iterator<Particle> iterator = p_187240_1_.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            particle.m_5989_();
            if (particle.m_107276_()) continue;
            iterator.remove();
        }
    }

    public void renderParticles(PoseStack ms, MultiBufferSource buffer, Camera renderInfo, float pt) {
        Minecraft mc = Minecraft.m_91087_();
        LightTexture lightTexture = mc.f_91063_.m_109154_();
        lightTexture.m_109896_();
        RenderSystem.m_69482_();
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_252931_(ms.m_85850_().m_252922_());
        RenderSystem.m_157182_();
        for (ParticleRenderType iparticlerendertype : this.byType.keySet()) {
            Iterable iterable;
            if (iparticlerendertype == ParticleRenderType.f_107434_ || (iterable = (Iterable)this.byType.get(iparticlerendertype)) == null) continue;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            iparticlerendertype.m_6505_(bufferbuilder, mc.f_90987_);
            for (Particle particle : iterable) {
                particle.m_5744_((VertexConsumer)bufferbuilder, renderInfo, pt);
            }
            iparticlerendertype.m_6294_(tessellator);
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69461_();
        lightTexture.m_109891_();
    }

    public void clearEffects() {
        this.byType.clear();
    }
}

