/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderTooltipHandler;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class NavigatableSimiScreen
extends AbstractSimiScreen {
    public static final String THINK_BACK = "ponder.think_back";
    protected int depthPointX;
    protected int depthPointY;
    public final LerpedFloat transition = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.LINEAR);
    protected final LerpedFloat arrowAnimation = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.075f, LerpedFloat.Chaser.LINEAR);
    protected PonderButton backTrack;

    public NavigatableSimiScreen() {
        Window window = Minecraft.m_91087_().m_91268_();
        this.depthPointX = window.m_85445_() / 2;
        this.depthPointY = window.m_85446_() / 2;
    }

    public void m_7379_() {
        ScreenOpener.clearStack();
        super.m_7379_();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.transition.tickChaser();
        this.arrowAnimation.tickChaser();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.backTrack = null;
        List<Screen> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return;
        }
        if (!(screenHistory.get(0) instanceof NavigatableSimiScreen)) {
            return;
        }
        NavigatableSimiScreen screen = (NavigatableSimiScreen)screenHistory.get(0);
        this.backTrack = (PonderButton)((AbstractSimiWidget)new PonderButton(31, this.f_96544_ - 31 - 20).enableFade(0, 5)).withCallback(() -> ScreenOpener.openPreviousScreen(this, Optional.empty()));
        this.m_142416_(this.backTrack);
        this.backTrack.fade(1.0f);
        screen.initBackTrackIcon(this.backTrack);
    }

    protected abstract void initBackTrackIcon(PonderButton var1);

    @Override
    public void m_86412_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(ms, mouseX, mouseY, partialTicks);
        if (this.backTrack == null) {
            return;
        }
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, 500.0f);
        if (this.backTrack.m_198029_()) {
            MutableComponent translate = Lang.translateDirect(this.backTrackingLangKey(), new Object[0]);
            this.f_96547_.m_92889_(ms, (Component)translate, (float)(41 - this.f_96547_.m_92852_((FormattedText)translate) / 2), (float)(this.f_96544_ - 16), Theme.i(Theme.Key.TEXT_DARKER));
            if (Mth.m_14033_((float)this.arrowAnimation.getValue(), (float)this.arrowAnimation.getChaseTarget())) {
                this.arrowAnimation.setValue(1.0);
                this.arrowAnimation.setValue(1.0);
            }
        }
        ms.m_85849_();
    }

    protected String backTrackingLangKey() {
        return THINK_BACK;
    }

    @Override
    protected void renderWindowBackground(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.backTrack != null) {
            int x = (int)Mth.m_14179_((float)this.arrowAnimation.getValue(partialTicks), (float)-9.0f, (float)21.0f);
            int maxX = this.backTrack.m_252754_() + this.backTrack.m_5711_();
            if (x + 30 < this.backTrack.m_252754_()) {
                UIRenderHelper.breadcrumbArrow(ms, x + 30, this.f_96544_ - 51, 0, maxX - (x + 30), 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
            }
            UIRenderHelper.breadcrumbArrow(ms, x, this.f_96544_ - 51, 0, 30, 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
            UIRenderHelper.breadcrumbArrow(ms, x - 30, this.f_96544_ - 51, 0, 30, 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
        }
        if (this.transition.getChaseTarget() == 0.0f || this.transition.settled()) {
            this.m_7333_(ms);
            return;
        }
        this.m_7333_(ms);
        Screen lastScreen = ScreenOpener.getPreviouslyRenderedScreen();
        float transitionValue = this.transition.getValue(partialTicks);
        float scale = 1.0f + 0.5f * transitionValue;
        if (lastScreen != null && lastScreen != this && !this.transition.settled()) {
            ms.m_85836_();
            UIRenderHelper.framebuffer.m_83954_(Minecraft.f_91002_);
            ms.m_252880_(0.0f, 0.0f, -1000.0f);
            UIRenderHelper.framebuffer.m_83947_(true);
            PonderTooltipHandler.enable = false;
            lastScreen.m_86412_(ms, mouseX, mouseY, partialTicks);
            PonderTooltipHandler.enable = true;
            ms.m_85849_();
            ms.m_85836_();
            this.f_96541_.m_91385_().m_83947_(true);
            Window window = this.f_96541_.m_91268_();
            int dpx = window.m_85445_() / 2;
            int dpy = window.m_85446_() / 2;
            if (lastScreen instanceof NavigatableSimiScreen) {
                NavigatableSimiScreen navigableScreen = (NavigatableSimiScreen)lastScreen;
                dpx = navigableScreen.depthPointX;
                dpy = navigableScreen.depthPointY;
            }
            ms.m_252880_((float)dpx, (float)dpy, 0.0f);
            ms.m_85841_(scale, scale, 1.0f);
            ms.m_252880_((float)(-dpx), (float)(-dpy), 0.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            UIRenderHelper.drawFramebuffer(1.0f - Math.abs(transitionValue));
            RenderSystem.m_69461_();
            ms.m_85849_();
        }
        scale = transitionValue > 0.0f ? 1.0f - 0.5f * (1.0f - transitionValue) : 1.0f + 0.5f * (1.0f + transitionValue);
        ms.m_252880_((float)this.depthPointX, (float)this.depthPointY, 0.0f);
        ms.m_85841_(scale, scale, 1.0f);
        ms.m_252880_((float)(-this.depthPointX), (float)(-this.depthPointY), 0.0f);
    }

    @Override
    public boolean m_7933_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (code == 259) {
            ScreenOpener.openPreviousScreen(this, Optional.empty());
            return true;
        }
        return super.m_7933_(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void centerScalingOn(int x, int y) {
        this.depthPointX = x;
        this.depthPointY = y;
    }

    public void centerScalingOnMouse() {
        Window w = this.f_96541_.m_91268_();
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
        this.centerScalingOn((int)mouseX, (int)mouseY);
    }

    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return false;
    }

    public void shareContextWith(NavigatableSimiScreen other) {
    }

    protected void renderZeloBreadcrumbs(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        List<Screen> history = ScreenOpener.getScreenHistory();
        if (history.isEmpty()) {
            return;
        }
        history.add(0, this.f_96541_.f_91080_);
        int spacing = 20;
        List<String> names = history.stream().map(NavigatableSimiScreen::screenTitle).collect(Collectors.toList());
        int bWidth = names.stream().mapToInt(s -> this.f_96547_.m_92895_(s) + spacing).sum();
        MutableInt x = new MutableInt(this.f_96543_ - bWidth);
        MutableInt y = new MutableInt(this.f_96544_ - 18);
        MutableBoolean first = new MutableBoolean(true);
        if (x.getValue() < 25) {
            x.setValue(25);
        }
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, 600.0f);
        names.forEach(s -> {
            int sWidth = this.f_96547_.m_92895_(s);
            UIRenderHelper.breadcrumbArrow(ms, x.getValue(), y.getValue(), 0, sWidth + spacing, 14, spacing / 2, new Color(-586149872), new Color(0x44101010));
            this.f_96547_.m_92883_(ms, s, (float)(x.getValue() + 5), (float)(y.getValue() + 3), first.getValue() != false ? -1114130 : -2232577);
            first.setFalse();
            x.add(sWidth + spacing);
        });
        ms.m_85849_();
    }

    private static String screenTitle(Screen screen) {
        if (screen instanceof NavigatableSimiScreen) {
            return ((NavigatableSimiScreen)screen).getBreadcrumbTitle();
        }
        return "<";
    }

    protected String getBreadcrumbTitle() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

