/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.jozufozu.flywheel.api.vertex.ShadedVertexList;
import com.jozufozu.flywheel.backend.ShadersModHandler;
import com.jozufozu.flywheel.core.vertex.BlockVertexList;
import com.jozufozu.flywheel.util.DiffuseLightCalculator;
import com.jozufozu.flywheel.util.transform.TStack;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.ForcedDiffuseState;
import com.simibubi.create.foundation.utility.Color;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class SuperByteBuffer
implements Transform<SuperByteBuffer>,
TStack<SuperByteBuffer> {
    private final ShadedVertexList template;
    private final PoseStack transforms;
    private boolean shouldColor;
    private int r;
    private int g;
    private int b;
    private int a;
    private boolean disableDiffuseMult;
    private DiffuseLightCalculator diffuseCalculator;
    private SpriteShiftFunc spriteShiftFunc;
    private boolean hasOverlay;
    private int overlay = OverlayTexture.f_118083_;
    private boolean useWorldLight;
    private Matrix4f lightTransform;
    private boolean hasCustomLight;
    private int packedLightCoords;
    private boolean hybridLight;
    private boolean fullNormalTransform;
    private static final Long2IntMap WORLD_LIGHT_CACHE = new Long2IntOpenHashMap();

    public SuperByteBuffer(BufferBuilder.RenderedBuffer buf, int unshadedStartVertex) {
        BufferBuilder.DrawState drawState = buf.m_231198_();
        this.template = new BlockVertexList.Shaded(buf.m_231196_(), drawState.f_85734_(), drawState.f_85733_().m_86020_(), unshadedStartVertex);
        this.transforms = new PoseStack();
        this.transforms.m_85836_();
    }

    public void renderInto(PoseStack input, VertexConsumer builder) {
        boolean disableDiffuseMult;
        Matrix3f normalMat;
        if (this.isEmpty()) {
            return;
        }
        Matrix4f modelMat = new Matrix4f((Matrix4fc)input.m_85850_().m_252922_());
        Matrix4f localTransforms = this.transforms.m_85850_().m_252922_();
        modelMat.mul((Matrix4fc)localTransforms);
        if (this.fullNormalTransform) {
            normalMat = new Matrix3f((Matrix3fc)input.m_85850_().m_252943_());
            Matrix3f localNormalTransforms = this.transforms.m_85850_().m_252943_();
            normalMat.mul((Matrix3fc)localNormalTransforms);
        } else {
            normalMat = new Matrix3f((Matrix3fc)this.transforms.m_85850_().m_252943_());
        }
        if (this.useWorldLight) {
            WORLD_LIGHT_CACHE.clear();
        }
        Vector4f pos = new Vector4f();
        Vector3f normal = new Vector3f();
        Vector4f lightPos = new Vector4f();
        DiffuseLightCalculator diffuseCalculator = ForcedDiffuseState.getForcedCalculator();
        boolean bl = disableDiffuseMult = this.disableDiffuseMult || ShadersModHandler.isShaderPackInUse() && diffuseCalculator == null;
        if (diffuseCalculator == null && (diffuseCalculator = this.diffuseCalculator) == null) {
            diffuseCalculator = DiffuseLightCalculator.forCurrentLevel();
        }
        int vertexCount = this.template.getVertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            int light;
            byte a;
            byte b;
            byte g;
            byte r;
            float x = this.template.getX(i);
            float y = this.template.getY(i);
            float z = this.template.getZ(i);
            pos.set(x, y, z, 1.0f);
            pos.mul((Matrix4fc)modelMat);
            builder.m_5483_((double)pos.x(), (double)pos.y(), (double)pos.z());
            float normalX = this.template.getNX(i);
            float normalY = this.template.getNY(i);
            float normalZ = this.template.getNZ(i);
            normal.set(normalX, normalY, normalZ);
            normal.mul((Matrix3fc)normalMat);
            float nx = normal.x();
            float ny = normal.y();
            float nz = normal.z();
            if (this.shouldColor) {
                r = (byte)this.r;
                g = (byte)this.g;
                b = (byte)this.b;
                a = (byte)this.a;
            } else {
                r = this.template.getR(i);
                g = this.template.getG(i);
                b = this.template.getB(i);
                a = this.template.getA(i);
            }
            if (disableDiffuseMult) {
                builder.m_6122_((int)r, (int)g, (int)b, (int)a);
            } else {
                float instanceDiffuse = diffuseCalculator.getDiffuse(nx, ny, nz, this.template.isShaded(i));
                int colorR = SuperByteBuffer.transformColor(r, instanceDiffuse);
                int colorG = SuperByteBuffer.transformColor(g, instanceDiffuse);
                int colorB = SuperByteBuffer.transformColor(b, instanceDiffuse);
                builder.m_6122_(colorR, colorG, colorB, (int)a);
            }
            float u = this.template.getU(i);
            float v = this.template.getV(i);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(builder, u, v);
            } else {
                builder.m_7421_(u, v);
            }
            if (this.hasOverlay) {
                builder.m_86008_(this.overlay);
            }
            if (this.useWorldLight) {
                lightPos.set((x - 0.5f) * 15.0f / 16.0f + 0.5f, (y - 0.5f) * 15.0f / 16.0f + 0.5f, (z - 0.5f) * 15.0f / 16.0f + 0.5f, 1.0f);
                lightPos.mul((Matrix4fc)localTransforms);
                if (this.lightTransform != null) {
                    lightPos.mul((Matrix4fc)this.lightTransform);
                }
                light = SuperByteBuffer.getLight((Level)Minecraft.m_91087_().f_91073_, lightPos);
                if (this.hasCustomLight) {
                    light = SuperByteBuffer.maxLight(light, this.packedLightCoords);
                }
            } else {
                light = this.hasCustomLight ? this.packedLightCoords : this.template.getLight(i);
            }
            if (this.hybridLight) {
                builder.m_85969_(SuperByteBuffer.maxLight(light, this.template.getLight(i)));
            } else {
                builder.m_85969_(light);
            }
            builder.m_5601_(nx, ny, nz);
            builder.m_5752_();
        }
        this.reset();
    }

    public SuperByteBuffer reset() {
        while (!this.transforms.m_85851_()) {
            this.transforms.m_85849_();
        }
        this.transforms.m_85836_();
        this.shouldColor = false;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.a = 0;
        this.disableDiffuseMult = false;
        this.diffuseCalculator = null;
        this.spriteShiftFunc = null;
        this.hasOverlay = false;
        this.overlay = OverlayTexture.f_118083_;
        this.useWorldLight = false;
        this.lightTransform = null;
        this.hasCustomLight = false;
        this.packedLightCoords = 0;
        this.hybridLight = false;
        this.fullNormalTransform = false;
        return this;
    }

    public boolean isEmpty() {
        return this.template.isEmpty();
    }

    public PoseStack getTransforms() {
        return this.transforms;
    }

    public SuperByteBuffer translate(double x, double y, double z) {
        this.transforms.m_85837_(x, y, z);
        return this;
    }

    public SuperByteBuffer multiply(Quaternionf quaternion) {
        this.transforms.m_252781_(quaternion);
        return this;
    }

    public SuperByteBuffer scale(float factorX, float factorY, float factorZ) {
        this.transforms.m_85841_(factorX, factorY, factorZ);
        return this;
    }

    public SuperByteBuffer pushPose() {
        this.transforms.m_85836_();
        return this;
    }

    public SuperByteBuffer popPose() {
        this.transforms.m_85849_();
        return this;
    }

    public SuperByteBuffer mulPose(Matrix4f pose) {
        this.transforms.m_85850_().m_252922_().mul((Matrix4fc)pose);
        return this;
    }

    public SuperByteBuffer mulNormal(Matrix3f normal) {
        this.transforms.m_85850_().m_252943_().mul((Matrix3fc)normal);
        return this;
    }

    public SuperByteBuffer transform(PoseStack stack) {
        this.transforms.m_85850_().m_252922_().mul((Matrix4fc)stack.m_85850_().m_252922_());
        this.transforms.m_85850_().m_252943_().mul((Matrix3fc)stack.m_85850_().m_252943_());
        return this;
    }

    public SuperByteBuffer rotateCentered(Direction axis, float radians) {
        ((SuperByteBuffer)this.translate(0.5, 0.5, 0.5).rotate(axis, radians)).translate(-0.5, -0.5, -0.5);
        return this;
    }

    public SuperByteBuffer rotateCentered(Quaternionf q) {
        this.translate(0.5, 0.5, 0.5).multiply(q).translate(-0.5, -0.5, -0.5);
        return this;
    }

    public SuperByteBuffer color(int r, int g, int b, int a) {
        this.shouldColor = true;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.shouldColor = true;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.a = 255;
        return this;
    }

    public SuperByteBuffer color(Color c) {
        return this.color(c.getRGB());
    }

    public SuperByteBuffer disableDiffuse() {
        this.disableDiffuseMult = true;
        return this;
    }

    public SuperByteBuffer diffuseCalculator(DiffuseLightCalculator diffuseCalculator) {
        this.diffuseCalculator = diffuseCalculator;
        return this;
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.spriteShiftFunc = (builder, u, v) -> builder.m_7421_(entry.getTargetU(u), entry.getTargetV(v));
        return this;
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollV) {
        return this.shiftUVScrolling(entry, 0.0f, scrollV);
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollU, float scrollV) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = u - entry.getOriginal().m_118409_() + entry.getTarget().m_118409_() + scrollU;
            float targetV = v - entry.getOriginal().m_118411_() + entry.getTarget().m_118411_() + scrollV;
            builder.m_7421_(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = entry.getTarget().m_118367_((double)(SpriteShiftEntry.getUnInterpolatedU(entry.getOriginal(), u) / (float)sheetSize + uTarget * 16.0f));
            float targetV = entry.getTarget().m_118393_((double)(SpriteShiftEntry.getUnInterpolatedV(entry.getOriginal(), v) / (float)sheetSize + vTarget * 16.0f));
            builder.m_7421_(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer overlay() {
        this.hasOverlay = true;
        return this;
    }

    public SuperByteBuffer overlay(int overlay) {
        this.hasOverlay = true;
        this.overlay = overlay;
        return this;
    }

    public SuperByteBuffer light() {
        this.useWorldLight = true;
        return this;
    }

    public SuperByteBuffer light(Matrix4f lightTransform) {
        this.useWorldLight = true;
        this.lightTransform = lightTransform;
        return this;
    }

    public SuperByteBuffer light(int packedLightCoords) {
        this.hasCustomLight = true;
        this.packedLightCoords = packedLightCoords;
        return this;
    }

    public SuperByteBuffer light(Matrix4f lightTransform, int packedLightCoords) {
        this.light(lightTransform);
        this.light(packedLightCoords);
        return this;
    }

    public SuperByteBuffer hybridLight() {
        this.hybridLight = true;
        return this;
    }

    public SuperByteBuffer fullNormalTransform() {
        this.fullNormalTransform = true;
        return this;
    }

    public SuperByteBuffer forEntityRender() {
        this.disableDiffuse();
        this.overlay();
        this.fullNormalTransform();
        return this;
    }

    public static int transformColor(byte component, float scale) {
        return Mth.m_14045_((int)((int)((float)Byte.toUnsignedInt(component) * scale)), (int)0, (int)255);
    }

    public static int transformColor(int component, float scale) {
        return Mth.m_14045_((int)((int)((float)component * scale)), (int)0, (int)255);
    }

    public static int maxLight(int packedLight1, int packedLight2) {
        int blockLight1 = LightTexture.m_109883_((int)packedLight1);
        int skyLight1 = LightTexture.m_109894_((int)packedLight1);
        int blockLight2 = LightTexture.m_109883_((int)packedLight2);
        int skyLight2 = LightTexture.m_109894_((int)packedLight2);
        return LightTexture.m_109885_((int)Math.max(blockLight1, blockLight2), (int)Math.max(skyLight1, skyLight2));
    }

    private static int getLight(Level world, Vector4f lightPos) {
        BlockPos pos = new BlockPos((double)lightPos.x(), (double)lightPos.y(), (double)lightPos.z());
        return WORLD_LIGHT_CACHE.computeIfAbsent(pos.m_121878_(), $ -> LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos));
    }

    @FunctionalInterface
    public static interface SpriteShiftFunc {
        public void shift(VertexConsumer var1, float var2, float var3);
    }

    @FunctionalInterface
    public static interface VertexLighter {
        public int getPackedLight(float var1, float var2, float var3);
    }
}

