/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.outliner.ChasingAABBOutline;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;

public class ValueBox
extends ChasingAABBOutline {
    protected Component label;
    protected Component sublabel = Components.immutableEmpty();
    protected Component scrollTooltip = Components.immutableEmpty();
    protected Vec3 labelOffset = Vec3.f_82478_;
    protected int passiveColor;
    protected int highlightColor;
    public boolean isPassive;
    protected BlockPos pos;
    protected ValueBoxTransform transform;
    protected BlockState blockState;

    public ValueBox(Component label, AABB bb, BlockPos pos) {
        super(bb);
        this.label = label;
        this.pos = pos;
        this.blockState = Minecraft.m_91087_().f_91073_.m_8055_(pos);
    }

    public ValueBox transform(ValueBoxTransform transform) {
        this.transform = transform;
        return this;
    }

    public ValueBox offsetLabel(Vec3 offset) {
        this.labelOffset = offset;
        return this;
    }

    public ValueBox subLabel(Component sublabel) {
        this.sublabel = sublabel;
        return this;
    }

    public ValueBox scrollTooltip(Component scrollTip) {
        this.scrollTooltip = scrollTip;
        return this;
    }

    public ValueBox withColors(int passive, int highlight) {
        this.passiveColor = passive;
        this.highlightColor = highlight;
        return this;
    }

    public ValueBox passive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, float pt) {
        boolean hasTransform;
        boolean bl = hasTransform = this.transform != null;
        if (this.transform instanceof ValueBoxTransform.Sided && this.params.getHighlightedFace() != null) {
            ((ValueBoxTransform.Sided)this.transform).fromSide(this.params.getHighlightedFace());
        }
        if (hasTransform && !this.transform.shouldRender(this.blockState)) {
            return;
        }
        ms.m_85836_();
        ms.m_252880_((float)this.pos.m_123341_(), (float)this.pos.m_123342_(), (float)this.pos.m_123343_());
        if (hasTransform) {
            this.transform.transform(this.blockState, ms);
        }
        this.transformNormals = new Matrix3f((Matrix3fc)ms.m_85850_().m_252943_());
        this.params.colored(this.isPassive ? this.passiveColor : this.highlightColor);
        super.render(ms, buffer, pt);
        float fontScale = hasTransform ? -this.transform.getFontScale() : -0.015625f;
        ms.m_85841_(fontScale, fontScale, fontScale);
        ms.m_85836_();
        this.renderContents(ms, buffer);
        ms.m_85849_();
        if (!this.isPassive) {
            ms.m_85836_();
            ms.m_85837_(17.5, -0.5, 7.0);
            ms.m_85837_(this.labelOffset.f_82479_, this.labelOffset.f_82480_, this.labelOffset.f_82481_);
            this.renderHoveringText(ms, buffer, this.label);
            if (!this.sublabel.getString().isEmpty()) {
                ms.m_252880_(0.0f, 10.0f, 0.0f);
                this.renderHoveringText(ms, buffer, this.sublabel);
            }
            if (!this.scrollTooltip.getString().isEmpty()) {
                ms.m_252880_(0.0f, 10.0f, 0.0f);
                this.renderHoveringText(ms, buffer, this.scrollTooltip, 0x998899, 0x111111);
            }
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public void renderContents(PoseStack ms, MultiBufferSource buffer) {
    }

    protected void renderHoveringText(PoseStack ms, MultiBufferSource buffer, Component text) {
        this.renderHoveringText(ms, buffer, text, this.highlightColor, Color.mixColors(this.passiveColor, 0, 0.75f));
    }

    protected void renderHoveringText(PoseStack ms, MultiBufferSource buffer, Component text, int color, int shadowColor) {
        ms.m_85836_();
        ValueBox.drawString(ms, buffer, text, 0.0f, 0.0f, color);
        ms.m_85837_(0.0, 0.0, -0.25);
        ValueBox.drawString(ms, buffer, text, 1.0f, 1.0f, shadowColor);
        ms.m_85849_();
    }

    private static void drawString(PoseStack ms, MultiBufferSource buffer, Component text, float x, float y, int color) {
        Minecraft.m_91087_().f_91062_.m_253181_(text, x, y, color, false, ms.m_85850_().m_252922_(), buffer, false, 0, 0xF000F0);
    }

    public static class IconValueBox
    extends ValueBox {
        AllIcons icon;

        public IconValueBox(Component label, INamedIconOptions iconValue, AABB bb, BlockPos pos) {
            super(label, bb, pos);
            this.subLabel((Component)Lang.translateDirect(iconValue.getTranslationKey(), new Object[0]));
            this.icon = iconValue.getIcon();
        }

        @Override
        public void renderContents(PoseStack ms, MultiBufferSource buffer) {
            super.renderContents(ms, buffer);
            float scale = 64.0f;
            ms.m_85841_(scale, scale, scale);
            ms.m_252880_(-0.5f, -0.5f, 0.03125f);
            this.icon.render(ms, buffer, 0xFFFFFF);
        }
    }

    public static class TextValueBox
    extends ValueBox {
        Component text;

        public TextValueBox(Component label, AABB bb, BlockPos pos, Component text) {
            super(label, bb, pos);
            this.text = text;
        }

        @Override
        public void renderContents(PoseStack ms, MultiBufferSource buffer) {
            boolean singleDigit;
            super.renderContents(ms, buffer);
            Font font = Minecraft.m_91087_().f_91062_;
            float scale = 4.0f;
            ms.m_85841_(scale, scale, 1.0f);
            ms.m_252880_(-4.0f, -4.0f, 5.0f);
            int stringWidth = font.m_92852_((FormattedText)this.text);
            Objects.requireNonNull(font);
            float numberScale = 9.0f / (float)stringWidth;
            boolean bl = singleDigit = stringWidth < 10;
            if (singleDigit) {
                numberScale /= 2.0f;
            }
            Objects.requireNonNull(font);
            float verticalMargin = (float)(stringWidth - 9) / 2.0f;
            ms.m_85841_(numberScale, numberScale, numberScale);
            ms.m_252880_(singleDigit ? (float)(stringWidth / 2) : 0.0f, singleDigit ? -verticalMargin : verticalMargin, 0.0f);
            this.renderHoveringText(ms, buffer, this.text, 0xEDEDED, 0x4F4F4F);
        }
    }

    public static class ItemValueBox
    extends ValueBox {
        ItemStack stack;
        int count;

        public ItemValueBox(Component label, AABB bb, BlockPos pos, ItemStack stack, int count) {
            super(label, bb, pos);
            this.stack = stack;
            this.count = count;
        }

        @Override
        public void renderContents(PoseStack ms, MultiBufferSource buffer) {
            super.renderContents(ms, buffer);
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent countString = Components.literal((String)(this.count == 0 ? "*" : "" + this.count));
            ms.m_252880_(17.5f, -5.0f, 7.0f);
            boolean isFilter = this.stack.m_41720_() instanceof FilterItem;
            boolean isEmpty = this.stack.m_41619_();
            float scale = 1.5f;
            ms.m_252880_((float)(-font.m_92852_((FormattedText)countString)), 0.0f, 0.0f);
            if (isFilter) {
                ms.m_252880_(3.0f, 8.0f, 7.25f);
            } else if (isEmpty) {
                ms.m_252880_(-17.0f, -2.0f, 3.0f);
                scale = 2.0f;
            } else {
                ms.m_252880_(-7.0f, 10.0f, 10.25f);
            }
            ms.m_85841_(scale, scale, scale);
            ValueBox.drawString(ms, buffer, (Component)countString, 0.0f, 0.0f, isFilter ? 0xFFFFFF : 0xEDEDED);
            ms.m_252880_(0.0f, 0.0f, -0.0625f);
            ValueBox.drawString(ms, buffer, (Component)countString, 0.875f, 0.875f, 0x4F4F4F);
        }
    }
}

