/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction;

import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EdgeInteractionHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.m_21120_(hand);
        if (player.m_6144_() || player.m_5833_()) {
            return;
        }
        EdgeInteractionBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, pos, EdgeInteractionBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (behaviour.requiredItem.isPresent() && behaviour.requiredItem.get() != heldItem.m_41720_()) {
            return;
        }
        BlockHitResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
        if (ray == null) {
            return;
        }
        Direction activatedDirection = EdgeInteractionHandler.getActivatedDirection(world, pos, ray.m_82434_(), ray.m_82450_(), behaviour);
        if (activatedDirection == null) {
            return;
        }
        if (event.getSide() != LogicalSide.CLIENT) {
            behaviour.connectionCallback.apply(world, pos, pos.m_121945_(activatedDirection));
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
        world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.25f, 0.1f);
    }

    public static List<Direction> getConnectiveSides(Level world, BlockPos pos, Direction face, EdgeInteractionBehaviour behaviour) {
        ArrayList<Direction> sides = new ArrayList<Direction>(6);
        if (BlockHelper.hasBlockSolidSide(world.m_8055_(pos.m_121945_(face)), (BlockGetter)world, pos.m_121945_(face), face.m_122424_())) {
            return sides;
        }
        for (Direction direction : Iterate.directions) {
            BlockPos neighbourPos;
            if (direction.m_122434_() == face.m_122434_() || BlockHelper.hasBlockSolidSide(world.m_8055_((neighbourPos = pos.m_121945_(direction)).m_121945_(face)), (BlockGetter)world, neighbourPos.m_121945_(face), face.m_122424_()) || !behaviour.connectivityPredicate.test(world, pos, face, direction)) continue;
            sides.add(direction);
        }
        return sides;
    }

    public static Direction getActivatedDirection(Level world, BlockPos pos, Direction face, Vec3 hit, EdgeInteractionBehaviour behaviour) {
        for (Direction facing : EdgeInteractionHandler.getConnectiveSides(world, pos, face, behaviour)) {
            AABB bb = EdgeInteractionHandler.getBB(pos, facing);
            if (!bb.m_82390_(hit)) continue;
            return facing;
        }
        return null;
    }

    static AABB getBB(BlockPos pos, Direction direction) {
        AABB bb = new AABB(pos);
        Vec3i vec = direction.m_122436_();
        int x = vec.m_123341_();
        int y = vec.m_123342_();
        int z = vec.m_123343_();
        double margin = 0.75;
        double absX = (double)Math.abs(x) * margin;
        double absY = (double)Math.abs(y) * margin;
        double absZ = (double)Math.abs(z) * margin;
        bb = bb.m_82310_(absX, absY, absZ);
        bb = bb.m_82386_(absX / 2.0, absY / 2.0, absZ / 2.0);
        bb = bb.m_82386_((double)x / 2.0, (double)y / 2.0, (double)z / 2.0);
        bb = bb.m_82400_(0.00390625);
        return bb;
    }
}

