/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.text.BreakIterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public final class FontHelper {
    private FontHelper() {
    }

    public static List<String> cutString(Font font, String text, int maxWidthPerLine) {
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(Minecraft.m_91087_().getLocale());
        iterator.setText(text);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = text.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.m_92895_(word);
            if (width + newWidth > maxWidthPerLine) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static void drawSplitString(PoseStack ms, Font font, String text, int x, int y, int width, int color) {
        List<String> list = FontHelper.cutString(font, text, width);
        Matrix4f matrix4f = ms.m_85850_().m_252922_();
        for (String s : list) {
            float f = x;
            if (font.m_92718_()) {
                int i = font.m_92895_(font.m_92801_(s));
                f += (float)(width - i);
            }
            FontHelper.draw(font, s, f, y, color, matrix4f, false);
            y += 9;
        }
    }

    private static int draw(Font font, String p_228078_1_, float p_228078_2_, float p_228078_3_, int p_228078_4_, Matrix4f p_228078_5_, boolean p_228078_6_) {
        if (p_228078_1_ == null) {
            return 0;
        }
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int i = font.m_252905_(p_228078_1_, p_228078_2_, p_228078_3_, p_228078_4_, p_228078_6_, p_228078_5_, (MultiBufferSource)irendertypebuffer$impl, false, 0, 0xF000F0);
        irendertypebuffer$impl.m_109911_();
        return i;
    }
}

