/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.worldgen.AllPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class AllBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ZINC_ORE = AllBiomeModifiers.key("zinc_ore");
    public static final ResourceKey<BiomeModifier> STRIATED_ORES_OVERWORLD = AllBiomeModifiers.key("striated_ores_overworld");
    public static final ResourceKey<BiomeModifier> STRIATED_ORES_NETHER = AllBiomeModifiers.key("striated_ores_nether");

    private static ResourceKey<BiomeModifier> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Create.asResource(name));
    }

    public static void bootstrap(BootstapContext<BiomeModifier> ctx) {
        HolderGetter biomeLookup = ctx.m_255420_(Registries.f_256952_);
        HolderSet.Named isOverworld = biomeLookup.m_254956_(BiomeTags.f_215817_);
        HolderSet.Named isNether = biomeLookup.m_254956_(BiomeTags.f_207612_);
        HolderGetter featureLookup = ctx.m_255420_(Registries.f_256988_);
        Holder.Reference zincOre = featureLookup.m_255043_(AllPlacedFeatures.ZINC_ORE);
        Holder.Reference striatedOresOverworld = featureLookup.m_255043_(AllPlacedFeatures.STRIATED_ORES_OVERWORLD);
        Holder.Reference striatedOresNether = featureLookup.m_255043_(AllPlacedFeatures.STRIATED_ORES_NETHER);
        ctx.m_255272_(ZINC_ORE, (Object)AllBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)zincOre));
        ctx.m_255272_(STRIATED_ORES_OVERWORLD, (Object)AllBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)striatedOresOverworld));
        ctx.m_255272_(STRIATED_ORES_NETHER, (Object)AllBiomeModifiers.addOre((HolderSet<Biome>)isNether, (Holder<PlacedFeature>)striatedOresNether));
    }

    private static ForgeBiomeModifiers.AddFeaturesBiomeModifier addOre(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{feature}), GenerationStep.Decoration.UNDERGROUND_ORES);
    }
}

