/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.forge.lootmanager;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.configs.forge.RSModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.misc.forge.lootmanager.EndRemasteredDedicatedLootApplier;
import com.telepathicgrunt.repurposedstructures.misc.lootmanager.StructureModdedLootImporter;
import com.telepathicgrunt.repurposedstructures.mixin.forge.resources.LootContextAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class StructureModdedLootImporterApplier
extends LootModifier {
    public static final Supplier<Codec<StructureModdedLootImporterApplier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> StructureModdedLootImporterApplier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, StructureModdedLootImporterApplier::new)));

    public StructureModdedLootImporterApplier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)RSModdedLootConfig.importModdedItems.get()).booleanValue() || StructureModdedLootImporter.isInBlacklist(context.getQueriedLootTableId())) {
            return generatedLoot;
        }
        ResourceLocation tableToImportLoot = StructureModdedLootImporter.TABLE_IMPORTS.get(context.getQueriedLootTableId());
        if (tableToImportLoot == null) {
            return generatedLoot;
        }
        LootContext newContext = StructureModdedLootImporterApplier.copyLootContextWithNewQueryID(context, tableToImportLoot);
        ObjectArrayList newlyGeneratedLoot = context.m_78940_(tableToImportLoot).m_230922_(newContext);
        newlyGeneratedLoot.removeIf(itemStack -> BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).m_135827_().equals("minecraft"));
        EndRemasteredDedicatedLootApplier.handleDedicatedModCompat((List<ItemStack>)newlyGeneratedLoot, context);
        generatedLoot.addAll((Collection)newlyGeneratedLoot);
        return generatedLoot;
    }

    protected static LootContext copyLootContextWithNewQueryID(LootContext oldLootContext, ResourceLocation newQueryID) {
        LootContext newContext = new LootContext.Builder(oldLootContext).m_78975_(LootContextParamSets.f_81411_);
        ((LootContextAccessor)newContext).repurposedstructures_setQueriedLootTableId(newQueryID);
        return newContext;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

