/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeilingVinePostProcessor
extends StructureProcessor {
    public static final Codec<CeilingVinePostProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("probability").stable().forGetter(ceilingVinePostProcessor -> Float.valueOf(ceilingVinePostProcessor.probability)), (App)BlockState.f_61039_.fieldOf("blockstate").forGetter(ceilingVinePostProcessor -> ceilingVinePostProcessor.blockState)).apply((Applicative)instance, instance.stable(CeilingVinePostProcessor::new)));
    private final float probability;
    private final BlockState blockState;

    public CeilingVinePostProcessor(float probability, BlockState blockState) {
        this.probability = probability;
        this.blockState = blockState;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.f_74676_.m_60795_()) {
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_188584_(structureBlockInfoWorld.f_74675_.m_121878_() * (long)structureBlockInfoWorld.f_74675_.m_123342_());
            ChunkAccess centerChunk = worldView.m_46865_(structureBlockInfoWorld.f_74675_);
            BlockState centerState = centerChunk.m_8055_(structureBlockInfoWorld.f_74675_);
            BlockPos abovePos = structureBlockInfoWorld.f_74675_.m_7494_();
            BlockState aboveState = centerChunk.m_8055_(abovePos);
            if (random.m_188501_() < this.probability && centerState.m_60795_() && Block.m_49918_((VoxelShape)aboveState.m_60812_((BlockGetter)worldView, abovePos), (Direction)Direction.DOWN)) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                List shuffledDirectionList = Direction.Plane.HORIZONTAL.m_122557_().collect(Collectors.toList());
                Collections.shuffle(shuffledDirectionList);
                block0: for (Direction facing : shuffledDirectionList) {
                    mutable.m_122190_((Vec3i)structureBlockInfoWorld.f_74675_).m_122173_(facing);
                    BlockState worldState = worldView.m_46865_((BlockPos)mutable).m_8055_((BlockPos)mutable);
                    if (worldState.m_60815_()) continue;
                    worldView.m_46865_((BlockPos)mutable).m_6978_((BlockPos)mutable, this.blockState, false);
                    BlockState vineBlock = (BlockState)((BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.m_57883_((Direction)facing), (Comparable)Boolean.valueOf(true))).m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true));
                    mutable.m_122173_(facing.m_122424_());
                    centerChunk.m_6978_((BlockPos)mutable, vineBlock, false);
                    vineBlock = (BlockState)vineBlock.m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false));
                    for (int depth = random.m_188503_(4); depth < 3; ++depth) {
                        mutable.m_122173_(Direction.DOWN);
                        if (!centerChunk.m_8055_((BlockPos)mutable).m_60795_()) break block0;
                        centerChunk.m_6978_((BlockPos)mutable, vineBlock, false);
                    }
                }
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return RSProcessors.CEILING_VINE_POST_PROCESSOR.get();
    }
}

