/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.TFConfig;
import twilightforest.block.SpecialMagicLogBlock;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.init.TFParticleType;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.WorldUtil;

public class SortLogCoreBlock
extends SpecialMagicLogBlock {
    public SortLogCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean doesCoreFunction() {
        return (Boolean)TFConfig.COMMON_CONFIG.MAGIC_TREES.disableSorting.get() == false;
    }

    @Override
    void performTreeEffect(Level level, BlockPos pos, RandomSource rand) {
        HashMap inputHandlers = new HashMap();
        HashMap outputHandlers = new HashMap();
        for (BlockPos blockPos : WorldUtil.getAllAround(pos, (Integer)TFConfig.COMMON_CONFIG.MAGIC_TREES.sortingRange.get())) {
            BlockEntity blockEntity;
            if (blockPos.equals((Object)pos) || (blockEntity = level.m_7702_(blockPos)) == null) continue;
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                if (Math.abs(blockPos.m_123341_() - pos.m_123341_()) <= 2 && Math.abs(blockPos.m_123342_() - pos.m_123342_()) <= 2 && Math.abs(blockPos.m_123343_() - pos.m_123343_()) <= 2) {
                    inputHandlers.put(iItemHandler, Vec3.m_82514_((Vec3i)blockPos, (double)1.9));
                } else {
                    outputHandlers.put(iItemHandler, Vec3.m_82514_((Vec3i)blockPos, (double)1.9));
                }
            });
        }
        level.m_6249_((Entity)null, new AABB(pos).m_82400_(2.0), entity -> entity.m_6084_() && entity.m_6095_().m_204039_(EntityTagGenerator.SORTABLE_ENTITIES)).forEach(entity -> entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(iItemHandler -> inputHandlers.put(iItemHandler, entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() + 0.9, 0.0))));
        if (inputHandlers.isEmpty()) {
            return;
        }
        level.m_6249_((Entity)null, new AABB(pos).m_82400_(16.0), entity -> entity.m_6084_() && entity.m_6095_().m_204039_(EntityTagGenerator.SORTABLE_ENTITIES)).forEach(entity -> entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(iItemHandler -> {
            if (!inputHandlers.containsKey(iItemHandler)) {
                outputHandlers.put(iItemHandler, entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() + 0.9, 0.0));
            }
        }));
        if (outputHandlers.isEmpty()) {
            return;
        }
        block1: for (IItemHandler inputIItemHandler : inputHandlers.keySet()) {
            for (int i = 0; i < inputIItemHandler.getSlots(); ++i) {
                ItemStack inputStack = inputIItemHandler.extractItem(i, 1, true);
                if (inputStack.m_41619_()) continue;
                boolean transferred = false;
                HashMap<Integer, IItemHandler> outputsByCount = new HashMap<Integer, IItemHandler>();
                for (IItemHandler outputIItemHandler : outputHandlers.keySet()) {
                    int count = 0;
                    for (int j = 0; j < outputIItemHandler.getSlots(); ++j) {
                        ItemStack stack = outputIItemHandler.getStackInSlot(j);
                        if (!stack.m_150930_(inputStack.m_41720_())) continue;
                        count += stack.m_41613_();
                    }
                    if (count <= 0) continue;
                    outputsByCount.put(count, outputIItemHandler);
                }
                for (Integer count : outputsByCount.keySet().stream().sorted(Comparator.comparingInt(Integer::intValue).reversed()).toList()) {
                    ItemStack newStack;
                    IItemHandler outputIItemHandler = (IItemHandler)outputsByCount.get(count);
                    int firstProperStack = -1;
                    for (int j = 0; j < outputIItemHandler.getSlots(); ++j) {
                        ItemStack outputStack = outputIItemHandler.getStackInSlot(j);
                        if (firstProperStack == -1 && outputStack.m_41619_()) {
                            firstProperStack = j;
                            continue;
                        }
                        if (!ItemStack.m_150942_((ItemStack)inputStack, (ItemStack)outputStack) || outputStack.m_41613_() >= outputStack.m_41741_() || outputStack.m_41613_() >= outputIItemHandler.getSlotLimit(j)) continue;
                        firstProperStack = j;
                        break;
                    }
                    if (firstProperStack == -1 || (newStack = inputIItemHandler.extractItem(i, 1, false)).m_41619_() || !outputIItemHandler.insertItem(firstProperStack, newStack, true).m_41619_()) continue;
                    outputIItemHandler.insertItem(firstProperStack, newStack, false);
                    transferred = true;
                    Vec3 xyz = (Vec3)outputHandlers.get(outputIItemHandler);
                    Vec3 diff = ((Vec3)inputHandlers.get(inputIItemHandler)).m_82546_(xyz);
                    for (ServerPlayer serverplayer : ((ServerLevel)level).m_6907_()) {
                        if (!(serverplayer.m_20238_(xyz) < 4096.0)) continue;
                        ParticlePacket particlePacket = new ParticlePacket();
                        double x = diff.f_82479_ - 0.25 + rand.m_188500_() * 0.5;
                        double y = diff.f_82480_ - 1.75 + rand.m_188500_() * 0.5;
                        double z = diff.f_82481_ - 0.25 + rand.m_188500_() * 0.5;
                        particlePacket.queueParticle((ParticleOptions)TFParticleType.SORTING_PARTICLE.get(), false, xyz, new Vec3(x, y, z).m_82490_(1.0 / diff.m_82553_()));
                        TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverplayer), (Object)particlePacket);
                    }
                }
                if (transferred) continue block1;
            }
        }
    }
}

