/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.HydraNeckModel;
import twilightforest.client.renderer.entity.HydraHeadRenderer;
import twilightforest.client.renderer.entity.TFPartRenderer;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.entity.boss.HydraNeck;

public class HydraNeckRenderer
extends TFPartRenderer<HydraNeck, HydraNeckModel> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("hydra4.png");

    public HydraNeckRenderer(EntityRendererProvider.Context manager) {
        super(manager, new HydraNeckModel(manager.m_174023_(TFModelLayers.HYDRA_NECK)));
    }

    @Override
    public void render(HydraNeck entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int light) {
        HydraHeadContainer headCon = HydraHeadRenderer.getHeadObject(entityIn.head);
        if (headCon != null && headCon.shouldRenderHead()) {
            float yawDiff = entityIn.m_146908_() - entityIn.f_19859_;
            if (yawDiff > 180.0f) {
                yawDiff -= 360.0f;
            } else if (yawDiff < -180.0f) {
                yawDiff += 360.0f;
            }
            float yaw2 = entityIn.f_19859_ + yawDiff * partialTicks;
            matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(yaw2 + 180.0f));
            super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, light);
        }
    }

    public ResourceLocation getTextureLocation(HydraNeck entity) {
        return textureLoc;
    }
}

