/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei.categories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.item.recipe.UncraftingRecipe;

public class JEIUncraftingCategory
implements IRecipeCategory<CraftingRecipe> {
    public static final RecipeType<CraftingRecipe> UNCRAFTING = RecipeType.create((String)"twilightforest", (String)"uncrafting", CraftingRecipe.class);
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public JEIUncraftingCategory(IGuiHelper guiHelper) {
        ResourceLocation location = TwilightForestMod.getGuiTexture("uncrafting_jei.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 116, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()));
        this.localizedName = Component.m_237115_((String)"gui.uncrafting_jei");
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return UNCRAFTING;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CraftingRecipe recipe, IFocusGroup focuses) {
        ArrayList<Ingredient> outputs = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.m_7527_());
        for (int i = 0; i < outputs.size(); ++i) {
            outputs.set(i, Ingredient.m_43921_(Arrays.stream(((Ingredient)outputs.get(i)).m_43908_()).filter(o -> !o.m_204117_(ItemTagGenerator.BANNED_UNCRAFTING_INGREDIENTS)).filter(o -> !o.m_41720_().hasCraftingRemainingItem(o))));
        }
        int k = 0;
        for (int j = 0; j - k < outputs.size() && j < 9; ++j) {
            int x = j % 3;
            int y = j / 3;
            if (recipe.m_8004_(x, 3) | recipe.m_8004_(3, y) && !(recipe instanceof ShapelessRecipe)) {
                ++k;
                continue;
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, x * 18 + 63, y * 18 + 1).addIngredients((Ingredient)outputs.get(j - k));
        }
        if (recipe instanceof UncraftingRecipe) {
            UncraftingRecipe uncraftingRecipe = (UncraftingRecipe)recipe;
            ItemStack[] stacks = uncraftingRecipe.getIngredient().m_43908_();
            ItemStack[] stackedStacks = new ItemStack[stacks.length];
            for (int i = 0; i < stacks.length; ++i) {
                stackedStacks[i] = new ItemStack((ItemLike)stacks[0].m_41720_(), uncraftingRecipe.count());
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 5, 19).addIngredients(Ingredient.m_43927_((ItemStack[])stackedStacks));
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 5, 19).addItemStack(recipe.m_8043_());
        }
    }
}

