/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.top;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import twilightforest.TwilightForestMod;
import twilightforest.util.ColorUtil;

public class QuestRamWoolElement
implements IElement {
    public static ResourceLocation ID = TwilightForestMod.prefix("quest_ram_wool");
    private final int colorData;

    public QuestRamWoolElement(int colorData) {
        this.colorData = colorData;
    }

    public QuestRamWoolElement(FriendlyByteBuf buf) {
        this.colorData = buf.readInt();
    }

    public boolean isColorPresent(DyeColor color) {
        return (this.colorData & 1 << color.m_41060_()) > 0;
    }

    public void render(PoseStack poseStack, int x, int y) {
        poseStack.m_85836_();
        RenderSystem.m_69482_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        PoseStack modelStack = RenderSystem.m_157191_();
        modelStack.m_252880_(3.0f, 10.0f, 0.0f);
        modelStack.m_85841_(0.6f, 0.6f, 0.6f);
        RenderSystem.m_157182_();
        int getRenderedWools = 0;
        int colum = 0;
        int row = 0;
        for (Map.Entry<DyeColor, Block> entry : ColorUtil.WOOL_TO_DYE_IN_RAM_ORDER.entrySet()) {
            if (this.isColorPresent(entry.getKey())) continue;
            if (getRenderedWools % 8 == 0) {
                ++row;
                colum = 0;
            } else {
                ++colum;
            }
            itemRenderer.m_115123_(new ItemStack((ItemLike)entry.getValue()), x + colum * 15, y + row * 15);
            ++getRenderedWools;
        }
        RenderSystem.m_69465_();
        poseStack.m_85849_();
    }

    public int getWidth() {
        return 4;
    }

    public int getHeight() {
        int getRenderedWools = 0;
        int row = 0;
        for (Map.Entry<DyeColor, Block> entry : ColorUtil.WOOL_TO_DYE_IN_RAM_ORDER.entrySet()) {
            if (this.isColorPresent(entry.getKey())) continue;
            if (getRenderedWools % 8 == 0) {
                ++row;
            }
            ++getRenderedWools;
        }
        return row * 10;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.colorData);
    }

    public ResourceLocation getID() {
        return ID;
    }

    public static enum Factory implements IElementFactory
    {
        INSTANCE;


        public IElement createElement(FriendlyByteBuf buf) {
            return new QuestRamWoolElement(buf);
        }

        public ResourceLocation getId() {
            return ID;
        }
    }
}

