/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.data.AdvancementProvider;
import twilightforest.data.AtlasGenerator;
import twilightforest.data.BlockstateGenerator;
import twilightforest.data.CraftingGenerator;
import twilightforest.data.ItemModelGenerator;
import twilightforest.data.LootGenerator;
import twilightforest.data.LootModifierGenerator;
import twilightforest.data.WorldGenerator;
import twilightforest.data.custom.CrumbleHornGenerator;
import twilightforest.data.custom.TransformationPowderGenerator;
import twilightforest.data.custom.UncraftingRecipeGenerator;
import twilightforest.data.custom.stalactites.StalactiteGenerator;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.data.tags.FluidTagGenerator;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.data.tags.StructureTagGenerator;

@Mod.EventBusSubscriber(modid="twilightforest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(output, provider, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockstateGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new AtlasGenerator(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new BiomeTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.BannerPatternTagGenerator(output, provider, helper));
        BlockTagGenerator blocktags = new BlockTagGenerator(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blocktags);
        generator.addProvider(event.includeServer(), (DataProvider)new FluidTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(output, provider, (TagsProvider<Block>)blocktags, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.EnchantmentTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)new CraftingGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)new LootModifierGenerator(output));
        WorldGenerator.addProviders(event.includeServer(), generator, output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)new StructureTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CrumbleHornGenerator(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new TransformationPowderGenerator(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UncraftingRecipeGenerator(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new StalactiteGenerator(output));
    }
}

