/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.tags;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBannerPatterns;
import twilightforest.init.custom.WoodPalettes;
import twilightforest.util.WoodPalette;

public class CustomTagGenerator {

    public static class WoodPaletteTagGenerator
    extends TagsProvider<WoodPalette> {
        public static final TagKey<WoodPalette> WELL_SWIZZLE_MASK = WoodPalettes.WOOD_PALETTES.createTagKey(TwilightForestMod.prefix("well_swizzle_mask"));
        public static final TagKey<WoodPalette> DRUID_HUT_SWIZZLE_MASK = WoodPalettes.WOOD_PALETTES.createTagKey(TwilightForestMod.prefix("druid_hut_swizzle_mask"));
        public static final TagKey<WoodPalette> COMMON_PALETTES = WoodPalettes.WOOD_PALETTES.createTagKey(TwilightForestMod.prefix("common"));
        public static final TagKey<WoodPalette> UNCOMMON_PALETTES = WoodPalettes.WOOD_PALETTES.createTagKey(TwilightForestMod.prefix("uncommon"));
        public static final TagKey<WoodPalette> RARE_PALETTES = WoodPalettes.WOOD_PALETTES.createTagKey(TwilightForestMod.prefix("rare"));
        public static final TagKey<WoodPalette> TREASURE_PALETTES = WoodPalettes.WOOD_PALETTES.createTagKey(TwilightForestMod.prefix("treasure"));

        public WoodPaletteTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper helper) {
            super(output, WoodPalettes.WOOD_PALETTE_TYPE_KEY, provider, "twilightforest", helper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(WELL_SWIZZLE_MASK).m_255204_(WoodPalettes.OAK);
            this.m_206424_(DRUID_HUT_SWIZZLE_MASK).m_211101_(new ResourceKey[]{WoodPalettes.OAK, WoodPalettes.SPRUCE, WoodPalettes.BIRCH});
            this.m_206424_(COMMON_PALETTES).m_211101_(new ResourceKey[]{WoodPalettes.SPRUCE, WoodPalettes.CANOPY});
            this.m_206424_(UNCOMMON_PALETTES).m_211101_(new ResourceKey[]{WoodPalettes.OAK, WoodPalettes.DARKWOOD, WoodPalettes.TWILIGHT_OAK});
            this.m_206424_(RARE_PALETTES).m_211101_(new ResourceKey[]{WoodPalettes.BIRCH, WoodPalettes.JUNGLE, WoodPalettes.MANGROVE});
            this.m_206424_(TREASURE_PALETTES).m_211101_(new ResourceKey[]{WoodPalettes.TIMEWOOD, WoodPalettes.TRANSWOOD, WoodPalettes.MINEWOOD, WoodPalettes.SORTWOOD});
        }

        public String m_6055_() {
            return "Twilight Forest Wood Palette Tags";
        }
    }

    public static class BannerPatternTagGenerator
    extends TagsProvider<BannerPattern> {
        public static final TagKey<BannerPattern> NAGA_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/naga");
        public static final TagKey<BannerPattern> LICH_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/lich");
        public static final TagKey<BannerPattern> MINOSHROOM_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/minoshroom");
        public static final TagKey<BannerPattern> HYDRA_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/hydra");
        public static final TagKey<BannerPattern> KNIGHT_PHANTOM_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/knight_phantom");
        public static final TagKey<BannerPattern> UR_GHAST_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/ur_ghast");
        public static final TagKey<BannerPattern> ALPHA_YETI_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/alpha_yeti");
        public static final TagKey<BannerPattern> SNOW_QUEEN_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/snow_queen");
        public static final TagKey<BannerPattern> QUEST_RAM_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/quest_ram");

        public BannerPatternTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.f_256969_, provider, "twilightforest", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(NAGA_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.NAGA.get())).get());
            this.m_206424_(LICH_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.LICH.get())).get());
            this.m_206424_(MINOSHROOM_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.MINOSHROOM.get())).get());
            this.m_206424_(HYDRA_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.HYDRA.get())).get());
            this.m_206424_(KNIGHT_PHANTOM_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.KNIGHT_PHANTOM.get())).get());
            this.m_206424_(UR_GHAST_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.UR_GHAST.get())).get());
            this.m_206424_(ALPHA_YETI_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.ALPHA_YETI.get())).get());
            this.m_206424_(SNOW_QUEEN_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.SNOW_QUEEN.get())).get());
            this.m_206424_(QUEST_RAM_BANNER_PATTERN).m_255204_((ResourceKey)BuiltInRegistries.f_256878_.m_7854_((Object)((BannerPattern)TFBannerPatterns.QUEST_RAM.get())).get());
        }

        private static TagKey<BannerPattern> create(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)TwilightForestMod.prefix(name));
        }

        public String m_6055_() {
            return "Twilight Forest Banner Pattern Tags";
        }
    }

    public static class EnchantmentTagGenerator
    extends TagsProvider<Enchantment> {
        public static final TagKey<Enchantment> PHANTOM_ARMOR_BANNED_ENCHANTS = TagKey.m_203882_((ResourceKey)Registries.f_256762_, (ResourceLocation)TwilightForestMod.prefix("phantom_armor_banned_enchants"));

        public EnchantmentTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper helper) {
            super(output, Registries.f_256762_, provider, "twilightforest", helper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(PHANTOM_ARMOR_BANNED_ENCHANTS).m_211101_(new ResourceKey[]{(ResourceKey)ForgeRegistries.ENCHANTMENTS.getResourceKey((Object)Enchantments.f_44963_).get(), (ResourceKey)ForgeRegistries.ENCHANTMENTS.getResourceKey((Object)Enchantments.f_44975_).get()});
        }

        public String m_6055_() {
            return "Twilight Forest Enchantment Tags";
        }
    }
}

