/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.monster.Redcap;

public abstract class RedcapBaseGoal
extends Goal {
    protected final Redcap redcap;

    protected RedcapBaseGoal(Redcap entity) {
        this.redcap = entity;
    }

    public boolean isTargetLookingAtMe(LivingEntity attackTarget) {
        double dx = this.redcap.m_20185_() - attackTarget.m_20185_();
        double dz = this.redcap.m_20189_() - attackTarget.m_20189_();
        float angle = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float difference = Mth.m_14154_((float)((attackTarget.m_146908_() - angle) % 360.0f));
        return difference < 60.0f || difference > 300.0f;
    }

    @Nullable
    public BlockPos findBlockTNTNearby(int range) {
        BlockPos entityPos = this.redcap.m_20183_();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    if (this.redcap.m_9236_().m_8055_(entityPos.m_7918_(x, y, z)).m_60734_() != Blocks.f_50077_) continue;
                    return entityPos.m_7918_(x, y, z);
                }
            }
        }
        return null;
    }

    public boolean isLitTNTNearby(int range) {
        AABB expandedBox = this.redcap.m_20191_().m_82377_((double)range, (double)range, (double)range);
        return !this.redcap.m_9236_().m_45976_(PrimedTnt.class, expandedBox).isEmpty();
    }
}

