/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import java.util.Objects;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.boss.AlphaYeti;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;

public class FallingIce
extends Entity {
    private int hangTime = 100;
    private BlockState blockState = Blocks.f_50354_.m_49966_();
    public int time;
    protected int fallDamageMax = 100;
    public float[] damagePerDifficulty = new float[]{1.0f, 1.0f, 3.0f, 6.0f};
    @Nullable
    public CompoundTag blockData;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(FallingIce.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public FallingIce(EntityType<? extends FallingIce> type, Level level) {
        super(type, level);
    }

    public FallingIce(Level level, double x, double y, double z, BlockState state, int hangTime) {
        this((EntityType<? extends FallingIce>)((EntityType)TFEntities.FALLING_ICE.get()), level);
        this.hangTime = hangTime;
        this.blockState = state;
        this.f_19850_ = true;
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.setStartPos(this.m_20183_());
    }

    public void setStartPos(BlockPos pos) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)pos);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    public boolean m_6097_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (this.blockState.m_60795_()) {
            this.m_146870_();
        } else {
            ++this.time;
            this.m_20242_(this.time < this.hangTime);
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.m_9236_().m_5776_()) {
                BlockHitResult blockhitresult;
                BlockPos blockpos = this.m_20183_();
                boolean flag = this.blockState.m_60734_() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.blockState.canBeHydrated((BlockGetter)this.f_19853_, blockpos, this.f_19853_.m_6425_(blockpos), blockpos);
                double d0 = this.m_20184_().m_82556_();
                if (flag && d0 > 1.0 && (blockhitresult = this.f_19853_.m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS && this.blockState.canBeHydrated((BlockGetter)this.m_9236_(), blockpos, this.m_9236_().m_6425_(blockhitresult.m_82425_()), blockhitresult.m_82425_())) {
                    blockpos = blockhitresult.m_82425_();
                    flag1 = true;
                }
                if (!this.f_19861_ && !flag1) {
                    if (!(this.m_9236_().m_5776_() || (this.time <= 100 || blockpos.m_123342_() > this.m_9236_().m_141937_() && blockpos.m_123342_() <= this.m_9236_().m_151558_()) && this.time <= 1000)) {
                        this.m_146870_();
                    }
                } else {
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (!blockstate.m_60713_(Blocks.f_50110_)) {
                        boolean flag4;
                        boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), blockpos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
                        boolean flag3 = FallingBlock.m_53241_((BlockState)this.m_9236_().m_8055_(blockpos.m_7495_())) && (!flag || !flag1);
                        boolean bl = flag4 = this.blockState.m_60710_((LevelReader)this.m_9236_(), blockpos) && !flag3;
                        if (flag2 && flag4) {
                            if (this.blockState.m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(blockpos).m_76152_() == Fluids.f_76193_) {
                                this.blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                            }
                            if (this.m_9236_().m_7731_(blockpos, this.blockState, 3)) {
                                BlockEntity blockentity;
                                ((ServerLevel)this.m_9236_()).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.m_9236_().m_8055_(blockpos)));
                                this.m_146870_();
                                if (this.blockData != null && this.blockState.m_155947_() && (blockentity = this.m_9236_().m_7702_(blockpos)) != null) {
                                    CompoundTag compoundtag = blockentity.m_187482_();
                                    for (String s : this.blockData.m_128431_()) {
                                        compoundtag.m_128365_(s, Objects.requireNonNull(this.blockData.m_128423_(s)).m_6426_());
                                    }
                                    try {
                                        blockentity.m_142466_(compoundtag);
                                    }
                                    catch (Exception exception) {
                                        TwilightForestMod.LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                    }
                                    blockentity.m_6596_();
                                }
                            }
                        } else {
                            this.m_146870_();
                        }
                    }
                }
            } else {
                this.makeTrail();
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    private void makeTrail() {
        for (int i = 0; i < 3; ++i) {
            double dx = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()));
            double dy = this.m_20186_() - (double)(4.0f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_())) - 3.0;
            double dz = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()));
            this.m_9236_().m_7107_((ParticleOptions)TFParticleType.EXTENDED_SNOW_WARNING.get(), dx, dy, dz, 0.0, -1.0, 0.0);
        }
    }

    public boolean m_142535_(float dist, float multiplier, DamageSource source) {
        int realDist = Mth.m_14167_((float)(dist - 1.0f));
        if (realDist >= 0) {
            float dmg = Math.min(Mth.m_14143_((float)((float)realDist * this.damagePerDifficulty[this.m_9236_().m_46791_().m_19028_()])), this.fallDamageMax);
            this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(1.0, 0.0, 1.0), EntitySelector.f_20408_).forEach(entity -> {
                if (!(entity instanceof AlphaYeti)) {
                    entity.m_6469_(DamageSource.m_253038_((Entity)this).m_238403_(), dmg);
                }
            });
        }
        for (int i = 0; i < 200; ++i) {
            double dx = this.m_20185_() + (double)(3.0f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()));
            double dy = this.m_20186_() + (double)(5.0f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()));
            double dz = this.m_20189_() + (double)(3.0f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()));
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.blockState), dx, dy, dz, 0.0, 0.0, 0.0);
        }
        this.m_5496_(Blocks.f_50354_.getSoundType(Blocks.f_50354_.m_49966_(), (LevelReader)this.m_9236_(), this.m_20183_(), null).m_56775_(), 3.0f, 0.5f);
        return false;
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        tag.m_128405_("Time", this.time);
        if (this.blockData != null) {
            tag.m_128365_("BlockEntityData", (Tag)this.blockData);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        this.blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("BlockState"));
        this.time = tag.m_128451_("Time");
        if (tag.m_128425_("BlockEntityData", 10)) {
            this.blockData = tag.m_128469_("BlockEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_50354_.m_49966_();
        }
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory category) {
        super.m_7976_(category);
        category.m_128159_("Imitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6127_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.blockState = Block.m_49803_((int)packet.m_131509_());
        this.f_19850_ = true;
        double d0 = packet.m_131500_();
        double d1 = packet.m_131501_();
        double d2 = packet.m_131502_();
        this.m_6034_(d0, d1, d2);
        this.setStartPos(this.m_20183_());
    }
}

