/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.monster.Kobold;
import twilightforest.init.TFLandmark;
import twilightforest.network.AreaProtectionPacket;
import twilightforest.network.EnforceProgressionStatusPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.structures.util.ProgressionStructure;
import twilightforest.world.registration.TFGenerationSettings;

@Mod.EventBusSubscriber(modid="twilightforest")
public class ProgressionEvents {
    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        Level level;
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level) || (level = (Level)levelAccessor).m_5776_()) {
            return;
        }
        if (ProgressionEvents.isBlockProtectedFromBreaking(level, pos) && ProgressionEvents.isAreaProtected(level, player, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (!level.m_5776_() && ProgressionEvents.isBlockProtectedFromInteraction(level, event.getPos()) && ProgressionEvents.isAreaProtected(level, player, event.getPos())) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    private static boolean isBlockProtectedFromInteraction(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(BlockTagGenerator.STRUCTURE_BANNED_INTERACTIONS);
    }

    private static boolean isBlockProtectedFromBreaking(Level level, BlockPos pos) {
        return !level.m_8055_(pos).m_204336_(BlockTagGenerator.PROGRESSION_ALLOW_BREAKING);
    }

    private static boolean isAreaProtected(Level level, Player player, BlockPos pos) {
        ProgressionStructure structureHints;
        Structure structure;
        StructureStart structureStart;
        Optional<StructureStart> struct;
        if (player.m_150110_().f_35937_ || player.m_5833_() || !LandmarkUtil.isProgressionEnforced(level) || player instanceof FakePlayer) {
            return false;
        }
        ChunkGeneratorTwilight chunkGenerator = WorldUtil.getChunkGenerator((LevelAccessor)level);
        if (chunkGenerator != null && (struct = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)level, SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()))).isPresent() && (structureStart = struct.get()).m_73601_().m_71051_((Vec3i)pos) && (structure = structureStart.m_226861_()) instanceof ProgressionStructure && !(structureHints = (ProgressionStructure)structure).doesPlayerHaveRequiredAdvancements(player)) {
            TFLandmark nearbyFeature = LegacyLandmarkPlacements.pickLandmarkAtBlock(pos.m_123341_(), pos.m_123343_(), (WorldGenLevel)((ServerLevel)level));
            if (nearbyFeature == TFLandmark.KNIGHT_STRONGHOLD && pos.m_123342_() >= 0) {
                return false;
            }
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            structureStart.m_73602_().forEach(piece -> {
                if (piece.m_73547_().m_71051_((Vec3i)pos)) {
                    boxes.add(piece.m_73547_());
                }
            });
            ProgressionEvents.sendAreaProtectionPacket(level, pos, boxes);
            structureHints.trySpawnHintMonster(level, player, pos);
            return true;
        }
        return false;
    }

    private static void sendAreaProtectionPacket(Level level, BlockPos pos, List<BoundingBox> sbb) {
        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 64.0, level.m_46472_());
        TFPacketHandler.CHANNEL.send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)new AreaProtectionPacket(sbb, pos));
    }

    @SubscribeEvent
    public static void livingAttack(LivingAttackEvent event) {
        LivingEntity living = event.getEntity();
        if (!living.m_9236_().m_5776_() && living instanceof Enemy && event.getSource().m_7639_() instanceof Player && !(living instanceof Kobold) && ProgressionEvents.isAreaProtected(living.m_9236_(), (Player)event.getSource().m_7639_(), new BlockPos((Vec3i)living.m_20183_()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player;
        Player player2;
        if (!event.getEntity().m_9236_().m_5776_() && (player2 = event.getEntity()) instanceof ServerPlayer && TFGenerationSettings.usesTwilightChunkGenerator((player = (ServerPlayer)player2).m_9236_())) {
            ProgressionEvents.sendEnforcedProgressionStatus(player, LandmarkUtil.isProgressionEnforced((Level)player.m_9236_()));
        }
    }

    @SubscribeEvent
    public static void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getEntity().m_9236_().m_5776_() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ProgressionEvents.sendEnforcedProgressionStatus(player2, LandmarkUtil.isProgressionEnforced(event.getEntity().m_9236_()));
        }
    }

    private static void sendEnforcedProgressionStatus(ServerPlayer player, boolean isEnforced) {
        TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EnforceProgressionStatusPacket(isEnforced));
    }
}

