/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFSounds;
import twilightforest.util.EntityUtil;

public class LifedrainScepterItem
extends Item {
    public LifedrainScepterItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41773_() == stack.m_41776_()) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public static void animateTargetShatter(ServerLevel level, LivingEntity target) {
        ItemStack itemId = Items.f_42583_.m_7968_();
        double explosionPower = level.m_213780_().m_188503_(100) == 0 ? 0.5 : 0.15;
        for (int i = 0; i < 50 + (int)target.f_19815_.f_20377_ * 75; ++i) {
            double gaussX = level.m_213780_().m_188583_() * 0.01;
            double gaussY = level.m_213780_().m_188583_() * 0.01;
            double gaussZ = level.m_213780_().m_188583_() * 0.01;
            double gaussFactor = 5.0;
            level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemId), target.m_20185_() + (double)(level.m_213780_().m_188501_() * target.m_20205_() * 1.5f) - (double)target.m_20205_() - gaussX * gaussFactor, target.m_20186_() + (double)(level.m_213780_().m_188501_() * target.m_20206_()) - gaussY * gaussFactor, target.m_20189_() + (double)(level.m_213780_().m_188501_() * target.m_20205_() * 1.5f) - (double)target.m_20205_() - gaussZ * gaussFactor, 1, gaussX, gaussY, gaussZ, level.m_213780_().m_188583_() * explosionPower);
        }
    }

    @Nullable
    private Entity getPlayerLookTarget(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3 srcVec = living.m_146892_();
        Vec3 lookVec = living.m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range);
        float var9 = 1.0f;
        List possibleList = level.m_45933_((Entity)living, living.m_20191_().m_82363_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range).m_82377_((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.m_6087_()) continue;
            float borderSize = possibleEntity.m_6143_();
            AABB collisionBB = possibleEntity.m_20191_().m_82377_((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        LivingEntity target;
        Entity pointedEntity;
        Level level = living.m_9236_();
        if (stack.m_41773_() == this.getMaxDamage(stack)) {
            living.m_5810_();
            return;
        }
        if (count % 5 == 0 && (pointedEntity = this.getPlayerLookTarget(level, living)) instanceof LivingEntity && !((target = (LivingEntity)pointedEntity) instanceof ArmorStand)) {
            if (level.m_5776_()) {
                this.makeRedMagicTrail(level, living, target.m_146892_());
            }
            if (target.m_6469_(TFDamageSources.lifedrain((Entity)living, living), 1.0f) && !level.m_5776_()) {
                Player player;
                if (target.m_21223_() <= 1.0f) {
                    if (!target.m_6095_().m_204039_(EntityTagGenerator.LIFEDRAIN_DROPS_NO_FLESH)) {
                        target.m_19983_(new ItemStack((ItemLike)Items.f_42583_, level.m_213780_().m_188503_(3)));
                        LifedrainScepterItem.animateTargetShatter((ServerLevel)level, target);
                    }
                    if (target instanceof Mob) {
                        Mob mob = (Mob)target;
                        mob.m_21373_();
                    }
                    target.m_5496_((SoundEvent)TFSounds.SCEPTER_DRAIN.get(), 1.0f, living.m_6100_());
                    SoundEvent deathSound = EntityUtil.getDeathSound(target);
                    if (deathSound != null) {
                        level.m_5594_(null, target.m_20183_(), deathSound, SoundSource.HOSTILE, 1.0f, target.m_6100_());
                    }
                    if (!target.m_21224_()) {
                        if (target instanceof Player) {
                            target.m_6469_(TFDamageSources.lifedrain((Entity)living, living), Float.MAX_VALUE);
                        } else {
                            target.m_6667_(TFDamageSources.lifedrain((Entity)living, living));
                            target.m_146870_();
                        }
                    }
                } else {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2));
                    if (count % 10 == 0) {
                        living.m_5634_(1.0f);
                        if (living instanceof Player) {
                            player = (Player)living;
                            player.m_36324_().m_38707_(1, 0.1f);
                        }
                    }
                }
                if (living instanceof Player && !(player = (Player)living).m_7500_()) {
                    stack.m_220157_(1, level.m_213780_(), null);
                }
            }
            if (!level.m_5776_() && target.m_21223_() <= living.m_21223_()) {
                target.m_20334_(0.0, 0.15, 0.0);
            }
        }
    }

    private void makeRedMagicTrail(Level level, LivingEntity source, Vec3 target) {
        int particles = 32;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = 1.0f;
            float f1 = 0.5f;
            float f2 = 0.5f;
            double handOffset = source.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)this) ? -0.35 : 0.35;
            double tx = source.m_20185_() + (target.m_7096_() - source.m_20185_()) * trailFactor + level.m_213780_().m_188583_() * 0.005 + handOffset * (double)Direction.m_122364_((double)source.f_20883_).m_122416_();
            double ty = source.m_20188_() - 0.1 + (target.m_7098_() - source.m_20188_()) * trailFactor + level.m_213780_().m_188583_() * 0.005 - 0.1;
            double tz = source.m_20189_() + (target.m_7094_() - source.m_20189_()) * trailFactor + level.m_213780_().m_188583_() * 0.005 + handOffset * (double)Direction.m_122364_((double)source.f_20883_).m_122416_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, tx, ty, tz, (double)f, (double)f1, (double)f2);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() == newStack.m_41720_();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.m_41720_() != oldStack.m_41720_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, level, tooltip, flags);
        tooltip.add((Component)Component.m_237110_((String)"twilightforest.scepter_charges", (Object[])new Object[]{stack.m_41776_() - stack.m_41773_()}).m_130940_(ChatFormatting.GRAY));
    }
}

