/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.recipe;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import twilightforest.init.TFItems;
import twilightforest.init.TFRecipes;

public class MoonwormQueenRepairRecipe
extends CustomRecipe {
    public MoonwormQueenRepairRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ItemStack queen = null;
        ArrayList<ItemStack> berries = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInQuestion = inv.m_8020_(i);
            if (stackInQuestion.m_41619_()) continue;
            if (stackInQuestion.m_150930_((Item)TFItems.MOONWORM_QUEEN.get()) && stackInQuestion.m_41768_()) {
                queen = stackInQuestion;
            }
            if (!stackInQuestion.m_150930_((Item)TFItems.TORCHBERRIES.get())) continue;
            berries.add(stackInQuestion);
        }
        return queen != null && !berries.isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ArrayList<Item> berries = new ArrayList<Item>();
        ItemStack queen = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_150930_((Item)TFItems.MOONWORM_QUEEN.get())) {
                if (queen == null) {
                    queen = itemstack;
                } else {
                    return ItemStack.f_41583_;
                }
            }
            if (!itemstack.m_150930_((Item)TFItems.TORCHBERRIES.get())) continue;
            berries.add(itemstack.m_41720_());
        }
        if (!berries.isEmpty() && queen != null && queen.m_41768_()) {
            ItemStack newQueen = ((Item)TFItems.MOONWORM_QUEEN.get()).m_7968_();
            newQueen.m_41721_(queen.m_41773_() - berries.size() * 64);
            return newQueen;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFRecipes.MOONWORM_QUEEN_REPAIR_RECIPE.get();
    }
}

