/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFRecipes;
import twilightforest.item.recipe.IUncraftingRecipe;

public record UncraftingRecipe(ResourceLocation recipeID, int cost, int width, int height, Ingredient ingredient, int count, NonNullList<Ingredient> resultItems) implements IUncraftingRecipe,
IShapedRecipe<CraftingContainer>
{
    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(CraftingContainer pContainer) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)Items.f_41852_, this.count);
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean isItemStackAnIngredient(ItemStack itemStack) {
        return Arrays.stream(this.ingredient.m_43908_()).anyMatch(i -> itemStack.m_41720_() == i.m_41720_() && itemStack.m_41613_() >= this.getCount());
    }

    public ResourceLocation m_6423_() {
        return this.recipeID;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFRecipes.UNCRAFTING_SERIALIZER.get();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return (RecipeType)TFRecipes.UNCRAFTING_RECIPE.get();
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public int getCost() {
        return this.cost;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.resultItems;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public static class Serializer
    implements RecipeSerializer<UncraftingRecipe> {
        public UncraftingRecipe fromJson(ResourceLocation id, JsonObject json) {
            int cost = GsonHelper.m_13927_((JsonObject)json, (String)"cost");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            int count = GsonHelper.m_13927_((JsonObject)json, (String)"count");
            Map<String, Ingredient> key = Serializer.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = Serializer.shrink(Serializer.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList<Ingredient> ingredients = Serializer.dissolvePattern(pattern, key, width, height);
            return new UncraftingRecipe(id, cost, width, height, ingredient, count, ingredients);
        }

        private static Map<String, Ingredient> keyFromJson(JsonObject json) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : json.entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
            }
            map.put(" ", Ingredient.f_43901_);
            return map;
        }

        static String[] shrink(String ... prePattern) {
            int i = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            int l = 0;
            for (int i1 = 0; i1 < prePattern.length; ++i1) {
                String s = prePattern[i1];
                i = Math.min(i, Serializer.firstNonSpace(s));
                int j1 = Serializer.lastNonSpace(s);
                j = Math.max(j, j1);
                if (j1 < 0) {
                    if (k == i1) {
                        ++k;
                    }
                    ++l;
                    continue;
                }
                l = 0;
            }
            if (prePattern.length == l) {
                return new String[0];
            }
            String[] shrunk = new String[prePattern.length - l - k];
            for (int k1 = 0; k1 < shrunk.length; ++k1) {
                shrunk[k1] = prePattern[k1 + k].substring(i, j + 1);
            }
            return shrunk;
        }

        private static int firstNonSpace(String first) {
            int i;
            for (i = 0; i < first.length() && first.charAt(i) == ' '; ++i) {
            }
            return i;
        }

        private static int lastNonSpace(String last) {
            int i;
            for (i = last.length() - 1; i >= 0 && last.charAt(i) == ' '; --i) {
            }
            return i;
        }

        private static String[] patternFromJson(JsonArray pattern) {
            String[] stringPattern = new String[pattern.size()];
            if (stringPattern.length > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
            }
            if (stringPattern.length == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            for (int i = 0; i < stringPattern.length; ++i) {
                String s = GsonHelper.m_13805_((JsonElement)pattern.get(i), (String)("pattern[" + i + "]"));
                if (s.length() > 3) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
                }
                if (i > 0 && stringPattern[0].length() != s.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                stringPattern[i] = s;
            }
            return stringPattern;
        }

        private static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> key, int width, int height) {
            NonNullList results = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            HashSet set = Sets.newHashSet(key.keySet());
            set.remove(" ");
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[i].length(); ++j) {
                    String s = pattern[i].substring(j, j + 1);
                    Ingredient ingredient = key.get(s);
                    if (ingredient == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                    }
                    set.remove(s);
                    results.set(j + width * i, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
            }
            return results;
        }

        @Nullable
        public UncraftingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int cost = buffer.m_130242_();
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            Ingredient result = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int count = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new UncraftingRecipe(id, cost, width, height, result, count, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, UncraftingRecipe recipe) {
            buffer.m_130130_(recipe.cost);
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130130_(recipe.count);
            for (Ingredient i : recipe.resultItems) {
                i.m_43923_(buffer);
            }
        }
    }
}

