/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record ColorUtil(Function<DyeColor, Block> function) {
    public static final ColorUtil WOOL = new ColorUtil(color -> switch (color) {
        default -> throw new IncompatibleClassChangeError();
        case DyeColor.WHITE -> Blocks.f_50041_;
        case DyeColor.ORANGE -> Blocks.f_50042_;
        case DyeColor.MAGENTA -> Blocks.f_50096_;
        case DyeColor.LIGHT_BLUE -> Blocks.f_50097_;
        case DyeColor.YELLOW -> Blocks.f_50098_;
        case DyeColor.LIME -> Blocks.f_50099_;
        case DyeColor.PINK -> Blocks.f_50100_;
        case DyeColor.GRAY -> Blocks.f_50101_;
        case DyeColor.LIGHT_GRAY -> Blocks.f_50102_;
        case DyeColor.CYAN -> Blocks.f_50103_;
        case DyeColor.PURPLE -> Blocks.f_50104_;
        case DyeColor.BLUE -> Blocks.f_50105_;
        case DyeColor.BROWN -> Blocks.f_50106_;
        case DyeColor.GREEN -> Blocks.f_50107_;
        case DyeColor.RED -> Blocks.f_50108_;
        case DyeColor.BLACK -> Blocks.f_50109_;
    });
    public static final ColorUtil TERRACOTTA = new ColorUtil(color -> switch (color) {
        default -> throw new IncompatibleClassChangeError();
        case DyeColor.WHITE -> Blocks.f_50287_;
        case DyeColor.ORANGE -> Blocks.f_50288_;
        case DyeColor.MAGENTA -> Blocks.f_50289_;
        case DyeColor.LIGHT_BLUE -> Blocks.f_50290_;
        case DyeColor.YELLOW -> Blocks.f_50291_;
        case DyeColor.LIME -> Blocks.f_50292_;
        case DyeColor.PINK -> Blocks.f_50293_;
        case DyeColor.GRAY -> Blocks.f_50294_;
        case DyeColor.LIGHT_GRAY -> Blocks.f_50295_;
        case DyeColor.CYAN -> Blocks.f_50296_;
        case DyeColor.PURPLE -> Blocks.f_50297_;
        case DyeColor.BLUE -> Blocks.f_50298_;
        case DyeColor.BROWN -> Blocks.f_50299_;
        case DyeColor.GREEN -> Blocks.f_50300_;
        case DyeColor.RED -> Blocks.f_50301_;
        case DyeColor.BLACK -> Blocks.f_50302_;
    });
    public static final ColorUtil STAINED_GLASS = new ColorUtil(color -> switch (color) {
        default -> throw new IncompatibleClassChangeError();
        case DyeColor.WHITE -> Blocks.f_50147_;
        case DyeColor.ORANGE -> Blocks.f_50148_;
        case DyeColor.MAGENTA -> Blocks.f_50202_;
        case DyeColor.LIGHT_BLUE -> Blocks.f_50203_;
        case DyeColor.YELLOW -> Blocks.f_50204_;
        case DyeColor.LIME -> Blocks.f_50205_;
        case DyeColor.PINK -> Blocks.f_50206_;
        case DyeColor.GRAY -> Blocks.f_50207_;
        case DyeColor.LIGHT_GRAY -> Blocks.f_50208_;
        case DyeColor.CYAN -> Blocks.f_50209_;
        case DyeColor.PURPLE -> Blocks.f_50210_;
        case DyeColor.BLUE -> Blocks.f_50211_;
        case DyeColor.BROWN -> Blocks.f_50212_;
        case DyeColor.GREEN -> Blocks.f_50213_;
        case DyeColor.RED -> Blocks.f_50214_;
        case DyeColor.BLACK -> Blocks.f_50215_;
    });
    public static final Map<DyeColor, Block> WOOL_TO_DYE_IN_RAM_ORDER = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{ColorUtil.entryOf(DyeColor.WHITE, Blocks.f_50041_), ColorUtil.entryOf(DyeColor.LIGHT_GRAY, Blocks.f_50102_), ColorUtil.entryOf(DyeColor.GRAY, Blocks.f_50101_), ColorUtil.entryOf(DyeColor.BLACK, Blocks.f_50109_), ColorUtil.entryOf(DyeColor.RED, Blocks.f_50108_), ColorUtil.entryOf(DyeColor.ORANGE, Blocks.f_50042_), ColorUtil.entryOf(DyeColor.YELLOW, Blocks.f_50098_), ColorUtil.entryOf(DyeColor.LIME, Blocks.f_50099_), ColorUtil.entryOf(DyeColor.GREEN, Blocks.f_50107_), ColorUtil.entryOf(DyeColor.LIGHT_BLUE, Blocks.f_50097_), ColorUtil.entryOf(DyeColor.CYAN, Blocks.f_50103_), ColorUtil.entryOf(DyeColor.BLUE, Blocks.f_50105_), ColorUtil.entryOf(DyeColor.PURPLE, Blocks.f_50104_), ColorUtil.entryOf(DyeColor.MAGENTA, Blocks.f_50096_), ColorUtil.entryOf(DyeColor.PINK, Blocks.f_50100_), ColorUtil.entryOf(DyeColor.BROWN, Blocks.f_50106_)});

    public BlockState getColor(DyeColor color) {
        return this.function.apply(color).m_49966_();
    }

    public Block getRandomColor(Random rand) {
        DyeColor color = DyeColor.m_41053_((int)rand.nextInt(16));
        return this.getColor(color).m_60734_();
    }

    public static float[] rgbToHSV(int r, int g, int b) {
        float s;
        float h = 0.0f;
        float rabs = (float)r / 255.0f;
        float gabs = (float)g / 255.0f;
        float babs = (float)b / 255.0f;
        float v = Math.max(rabs, Math.max(gabs, babs));
        float diff = v - Math.min(rabs, Math.min(gabs, babs));
        Function<Float, Float> diffc = c -> Float.valueOf((v - c.floatValue()) / 6.0f / diff + 0.0f);
        if (diff == 0.0f) {
            s = 0.0f;
            h = 0.0f;
        } else {
            s = diff / v;
            float rr = diffc.apply(Float.valueOf(rabs)).floatValue();
            float gg = diffc.apply(Float.valueOf(gabs)).floatValue();
            float bb = diffc.apply(Float.valueOf(babs)).floatValue();
            if (rabs == v) {
                h = bb - gg;
            } else if (gabs == v) {
                h = 0.33333334f + rr - bb;
            } else if (babs == v) {
                h = 0.6666667f + gg - rr;
            }
            if (h < 0.0f) {
                h += 1.0f;
            } else if (h > 1.0f) {
                h -= 1.0f;
            }
        }
        return new float[]{h, s, v};
    }

    public static int hsvToRGB(float hue, float saturation, float value) {
        float normaliedHue = hue - (float)Math.floor(hue);
        int h = (int)(normaliedHue * 6.0f);
        float f = normaliedHue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        return switch (h) {
            case 0 -> ColorUtil.rgb(value, t, p);
            case 1 -> ColorUtil.rgb(q, value, p);
            case 2 -> ColorUtil.rgb(p, value, t);
            case 3 -> ColorUtil.rgb(p, q, value);
            case 4 -> ColorUtil.rgb(t, p, value);
            case 5 -> ColorUtil.rgb(value, p, q);
            default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
        };
    }

    private static int rgb(float r, float g, float b) {
        return ((int)(r * 255.0f + 0.5f) & 0xFF) << 16 | ((int)(g * 255.0f + 0.5f) & 0xFF) << 8 | (int)(b * 255.0f + 0.5f) & 0xFF;
    }

    public static int argbToABGR(int argbColor) {
        int r = argbColor >> 16 & 0xFF;
        int b = argbColor & 0xFF;
        return argbColor & 0xFF00FF00 | b << 16 | r;
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }
}

