/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Method LivingEntity_getDeathSound = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_5592_", (Class[])new Class[0]);
    private static final MethodHandle handle_LivingEntity_getDeathSound;

    public static BlockPos bossChestLocation(Mob boss) {
        return boss.m_21534_() == BlockPos.f_121853_ ? boss.m_20183_() : boss.m_21534_().m_7495_();
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, Entity entity) {
        return EntityUtil.canDestroyBlock(world, pos, world.m_8055_(pos), entity);
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, BlockState state, Entity entity) {
        float hardness = state.m_60800_((BlockGetter)world, pos);
        return hardness >= 0.0f && hardness < 50.0f && !state.m_60795_() && state.m_60734_().canEntityDestroy(state, (BlockGetter)world, pos, entity) && (!(entity instanceof LivingEntity) || ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)entity), (BlockPos)pos, (BlockState)state));
    }

    public static BlockHitResult rayTrace(Entity entity, double range) {
        Vec3 position = entity.m_20299_(1.0f);
        Vec3 look = entity.m_20252_(1.0f);
        Vec3 dest = position.m_82520_(look.f_82479_ * range, look.f_82480_ * range, look.f_82481_ * range);
        return entity.f_19853_.m_45547_(new ClipContext(position, dest, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
    }

    public static BlockHitResult rayTrace(Player player) {
        return EntityUtil.rayTrace(player, null);
    }

    public static BlockHitResult rayTrace(Player player, @Nullable DoubleUnaryOperator modifier) {
        double range = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        return EntityUtil.rayTrace((Entity)player, modifier == null ? range : modifier.applyAsDouble(range));
    }

    @Nullable
    public static SoundEvent getDeathSound(LivingEntity living) {
        SoundEvent sound = null;
        if (handle_LivingEntity_getDeathSound != null) {
            try {
                sound = handle_LivingEntity_getDeathSound.invokeExact(living);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sound;
    }

    public static void killLavaAround(Entity entity) {
        AABB bounds = entity.m_20191_().m_82400_(9.0);
        for (double x = bounds.f_82288_; x < bounds.f_82291_; x += 1.0) {
            for (double z = bounds.f_82290_; z < bounds.f_82293_; z += 1.0) {
                for (double y = bounds.f_82289_; y < bounds.f_82292_; y += 1.0) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = entity.m_9236_().m_8055_(pos);
                    if (!state.m_60713_(Blocks.f_49991_)) continue;
                    entity.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    static {
        MethodHandle tmp_handle_LivingEntity_getDeathSound = null;
        try {
            tmp_handle_LivingEntity_getDeathSound = LOOKUP.unreflect(LivingEntity_getDeathSound);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        handle_LivingEntity_getDeathSound = tmp_handle_LivingEntity_getDeathSound;
    }
}

