/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.data.tags.BlockTagGenerator;

public final class FeatureLogic {
    public static final Predicate<BlockState> IS_REPLACEABLE_AIR = state -> state.m_60767_().m_76336_() || state.m_60795_();
    public static final Predicate<BlockState> ROOT_SHOULD_SKIP = state -> state.m_204336_(BlockTagGenerator.ROOT_TRACE_SKIP);

    public static boolean hasEmptyHorizontalNeighbor(LevelSimulatedReader worldReader, BlockPos pos) {
        return worldReader.m_7433_(pos.m_122012_(), IS_REPLACEABLE_AIR) || worldReader.m_7433_(pos.m_122019_(), IS_REPLACEABLE_AIR) || worldReader.m_7433_(pos.m_122024_(), IS_REPLACEABLE_AIR) || worldReader.m_7433_(pos.m_122029_(), IS_REPLACEABLE_AIR);
    }

    public static boolean hasSolidNeighbor(LevelSimulatedReader worldReader, BlockPos pos) {
        return !worldReader.m_7433_(pos.m_7495_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_122012_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_122019_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_122024_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_122029_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_7494_(), IS_REPLACEABLE_AIR);
    }

    public static boolean canRootGrowIn(LevelSimulatedReader worldReader, BlockPos pos) {
        if (worldReader.m_7433_(pos, IS_REPLACEABLE_AIR)) {
            return FeatureLogic.hasSolidNeighbor(worldReader, pos);
        }
        return worldReader.m_7433_(pos, FeatureLogic::worldGenReplaceable);
    }

    public static boolean worldGenReplaceable(BlockState state) {
        return (state.m_60767_().m_76336_() || state.m_204336_(BlockTagGenerator.WORLDGEN_REPLACEABLES)) && !state.m_204336_(BlockTags.f_144287_);
    }

    public static BlockPos translate(BlockPos pos, double distance, double angle, double tilt) {
        double rangle = angle * 2.0 * Math.PI;
        double rtilt = tilt * Math.PI;
        return pos.m_7637_((double)Math.round(Math.sin(rangle) * Math.sin(rtilt) * distance), (double)Math.round(Math.cos(rtilt) * distance), (double)Math.round(Math.cos(rangle) * Math.sin(rtilt) * distance));
    }

    @Deprecated
    public static BlockState randStone(RandomSource rand, int howMuch) {
        return rand.m_188503_(howMuch) >= 1 ? Blocks.f_50652_.m_49966_() : Blocks.f_50079_.m_49966_();
    }
}

