/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.server.ServerLifecycleHooks;
import twilightforest.init.TFDimensionSettings;
import twilightforest.world.components.chunkgenerators.warp.TerrainColumn;
import twilightforest.world.components.layer.GenLayerTFBiomeStabilize;
import twilightforest.world.components.layer.GenLayerTFBiomes;
import twilightforest.world.components.layer.GenLayerTFCompanionBiomes;
import twilightforest.world.components.layer.GenLayerTFKeyBiomes;
import twilightforest.world.components.layer.GenLayerTFRiverMix;
import twilightforest.world.components.layer.GenLayerTFStream;
import twilightforest.world.components.layer.GenLayerTFThornBorder;
import twilightforest.world.components.layer.vanillalegacy.Layer;
import twilightforest.world.components.layer.vanillalegacy.SmoothLayer;
import twilightforest.world.components.layer.vanillalegacy.ZoomLayer;
import twilightforest.world.components.layer.vanillalegacy.area.Area;
import twilightforest.world.components.layer.vanillalegacy.area.AreaFactory;
import twilightforest.world.components.layer.vanillalegacy.context.BigContext;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;

@Deprecated
public class TFBiomeProvider
extends BiomeSource {
    public static final Codec<TFBiomeProvider> TF_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().orElseGet(() -> TFDimensionSettings.seed).forGetter(o -> o.seed), (App)RegistryOps.m_255175_((ResourceKey)Registries.f_256952_), (App)TerrainColumn.CODEC.listOf().fieldOf("biome_landscape").xmap(l -> l.stream().collect(Collectors.toMap(TerrainColumn::getResourceKey, Function.identity())), m -> m.values().stream().sorted(Comparator.comparing(TerrainColumn::getResourceKey)).toList()).forGetter(o -> o.biomeList), (App)Codec.FLOAT.fieldOf("base_offset").forGetter(o -> Float.valueOf(o.baseOffset)), (App)Codec.FLOAT.fieldOf("base_factor").forGetter(o -> Float.valueOf(o.baseFactor))).apply((Applicative)instance, instance.stable(TFBiomeProvider::new)));
    private final HolderGetter<Biome> registry;
    private final Map<ResourceKey<Biome>, TerrainColumn> biomeList;
    private final Layer genBiomes;
    private final long seed;
    private final float baseOffset;
    private final float baseFactor;

    public TFBiomeProvider(long seed, HolderGetter<Biome> registry, List<TerrainColumn> list, float offset, float factor) {
        this(seed, registry, list.stream().collect(Collectors.toMap(TerrainColumn::getResourceKey, Function.identity())), offset, factor);
    }

    public TFBiomeProvider(long seed, HolderGetter<Biome> registryIn, Map<ResourceKey<Biome>, TerrainColumn> list, float offset, float factor) {
        super(list.values().stream().flatMap(TerrainColumn::getBiomes));
        this.seed = seed;
        this.baseOffset = offset;
        this.baseFactor = factor;
        this.registry = registryIn;
        this.biomeList = list;
        this.genBiomes = TFBiomeProvider.makeLayers(seed, registryIn);
    }

    public static int getBiomeId(ResourceKey<Biome> biome, HolderGetter<Biome> registry) {
        return ServerLifecycleHooks.getCurrentServer().m_206579_().m_175515_(Registries.f_256952_).m_7447_((Object)((Biome)((Holder.Reference)registry.m_254902_(biome).get()).get()));
    }

    private static <T extends Area, C extends BigContext<T>> AreaFactory<T> makeLayers(LongFunction<C> seed, HolderGetter<Biome> registry, long rawSeed) {
        AreaFactory biomes = GenLayerTFBiomes.INSTANCE.setup(registry).run((BigContext)seed.apply(1L));
        biomes = GenLayerTFKeyBiomes.INSTANCE.setup(registry, rawSeed).run((BigContext)seed.apply(1000L), biomes);
        biomes = GenLayerTFCompanionBiomes.INSTANCE.setup(registry).run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1001L), biomes);
        biomes = GenLayerTFBiomeStabilize.INSTANCE.run((BigContext)seed.apply(700L), biomes);
        biomes = GenLayerTFThornBorder.INSTANCE.setup(registry).run((BigContext)seed.apply(500L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1005L), biomes);
        AreaFactory riverLayer = GenLayerTFStream.INSTANCE.setup(registry).run((BigContext)seed.apply(1L), biomes);
        riverLayer = SmoothLayer.INSTANCE.run((BigContext)seed.apply(7000L), riverLayer);
        biomes = GenLayerTFRiverMix.INSTANCE.setup(registry).run((BigContext)seed.apply(100L), biomes, riverLayer);
        return biomes;
    }

    public static Layer makeLayers(long seed, HolderGetter<Biome> registry) {
        AreaFactory areaFactory = TFBiomeProvider.makeLayers(context -> new LazyAreaContext(25, seed, context), registry, seed);
        return new Layer(areaFactory){

            @Override
            public Holder<Biome> get(HolderGetter<Biome> registry, int p_242936_2_, int p_242936_3_) {
                int i = this.area.get(p_242936_2_, p_242936_3_);
                Optional biome = ServerLifecycleHooks.getCurrentServer().m_206579_().m_175515_(Registries.f_256952_).m_203300_(i);
                if (biome.isEmpty()) {
                    throw new IllegalStateException("Unknown biome id emitted by layers: " + i);
                }
                return (Holder)biome.get();
            }
        };
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return TF_CODEC;
    }

    public float getBaseOffset() {
        return this.baseOffset;
    }

    public float getBaseFactor() {
        return this.baseFactor;
    }

    public float getBiomeDepth(int x, int z) {
        return this.getBiomeDepth(this.genBiomes.get(this.registry, x, z));
    }

    public float getBiomeDepth(Holder<Biome> biome) {
        return this.getBiomeValue(biome, TerrainColumn::depth, Float.valueOf(0.0f)).floatValue();
    }

    public Optional<TerrainColumn> getTerrainColumn(int x, int z) {
        return this.getTerrainColumn(this.genBiomes.get(this.registry, x, z));
    }

    public Optional<TerrainColumn> getTerrainColumn(Holder<Biome> biome) {
        return this.biomeList.values().stream().filter(p -> p.is(biome)).findFirst();
    }

    public <T> T getBiomeValue(Holder<Biome> biome, Function<TerrainColumn, T> function, T other) {
        return this.getTerrainColumn(biome).map(function).orElse(other);
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        Holder<Biome> columnBiome = this.genBiomes.get(this.registry, x, z);
        return this.biomeList.get(columnBiome.m_203543_().get()).getBiome(y, columnBiome);
    }
}

