/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.templates;

import com.google.common.collect.ImmutableSet;
import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Material;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.monster.Wraith;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructureProcessors;
import twilightforest.loot.TFLootTables;

public class GraveyardFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation GRAVEYARD = TwilightForestMod.prefix("feature/graveyard/graveyard");
    private static final ResourceLocation TRAP = TwilightForestMod.prefix("feature/graveyard/grave_trap");
    private static final ImmutableSet<Material> MATERIAL_WHITELIST = ImmutableSet.of((Object)Material.f_76314_, (Object)Material.f_76315_, (Object)Material.f_76274_, (Object)Material.f_76320_, (Object)Material.f_76300_, (Object)Material.f_76278_, (Object[])new Material[0]);

    public GraveyardFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    private static boolean offsetToAverageGroundLevel(WorldGenLevel world, BlockPos.MutableBlockPos startPos, Vec3i size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.m_123341_(); ++dx) {
            for (int dz = 0; dz < size.m_123343_(); ++dz) {
                int y;
                int x = startPos.m_123341_() + dx;
                int z = startPos.m_123343_() + dz;
                for (y = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z); y >= 0; --y) {
                    BlockState state = world.m_8055_(new BlockPos(x, y, z));
                    if (GraveyardFeature.isBlockNotOk(state)) {
                        return false;
                    }
                    if (GraveyardFeature.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)Math.round(heights.mean());
        int maxY = (int)heights.max();
        startPos.m_142448_(baseY);
        return GraveyardFeature.isAreaClear((BlockGetter)world, startPos.m_6630_(maxY - baseY + 1), startPos.m_121955_(size));
    }

    private static boolean isAreaClear(BlockGetter world, BlockPos min, BlockPos max) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            Material material = world.m_8055_(pos).m_60767_();
            if (material.m_76336_() || MATERIAL_WHITELIST.contains((Object)material) || material.m_76332_()) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockOk(BlockState state) {
        Material material = state.m_60767_();
        return material == Material.f_76278_ || material == Material.f_76314_ || material == Material.f_76315_ || material == Material.f_76317_;
    }

    private static boolean isBlockNotOk(BlockState state) {
        Material material = state.m_60767_();
        return material == Material.f_76305_ || material == Material.f_76307_ || state.m_60734_() == Blocks.f_50752_;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        RandomSource rand = ctx.m_225041_();
        int flags = 19;
        StructureTemplateManager templatemanager = world.m_6018_().m_7654_().m_236738_();
        StructureTemplate base = templatemanager.m_230359_(GRAVEYARD);
        if (base == null) {
            return false;
        }
        ArrayList<Pair> graves = new ArrayList<Pair>();
        StructureTemplate trap = templatemanager.m_230359_(TRAP);
        if (trap == null) {
            return false;
        }
        for (GraveType type : GraveType.VALUES) {
            StructureTemplate grave = templatemanager.m_230359_(type.RL);
            if (grave == null) {
                return false;
            }
            graves.add(Pair.of((Object)((Object)type), (Object)grave));
        }
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[rand.m_188503_(rotations.length)];
        Mirror[] mirrors = Mirror.values();
        Mirror mirror = mirrors[rand.m_188503_(mirrors.length + 1) % mirrors.length];
        Vec3i transformedSize = base.m_163808_(rotation);
        Vec3i transformedGraveSize = ((StructureTemplate)((Pair)graves.get(0)).getValue()).m_163808_(rotation);
        ChunkPos chunkpos = new ChunkPos(pos.m_7918_(-8, 0, -8));
        ChunkPos chunkendpos = new ChunkPos(pos.m_7918_(-8, 0, -8).m_121955_(transformedSize));
        BoundingBox structureboundingbox = new BoundingBox(chunkpos.m_45604_() + 8, 0, chunkpos.m_45605_() + 8, chunkendpos.m_45608_() + 8, 255, chunkendpos.m_45609_() + 8);
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74377_(mirror).m_74379_(rotation).m_74381_(structureboundingbox).m_230324_(rand);
        BlockPos posSnap = chunkpos.m_45615_().m_7918_(8, pos.m_123342_() - 1, 8);
        BlockPos.MutableBlockPos startPos = new BlockPos.MutableBlockPos(posSnap.m_123341_(), posSnap.m_123342_(), posSnap.m_123343_());
        if (!GraveyardFeature.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        BlockPos placementPos = base.m_74583_((BlockPos)startPos, mirror, rotation).m_7918_(1, -1, 0);
        Vec3i size = transformedSize.m_7918_(-1, 0, -1);
        Vec3i graveSize = transformedGraveSize.m_7918_(-1, 0, -1);
        base.m_230328_((ServerLevelAccessor)world, placementPos, placementPos, placementsettings.m_74383_((StructureProcessor)new WebTemplateProcessor()), rand, flags);
        ArrayList data = new ArrayList(base.m_74603_(placementPos, placementsettings, Blocks.f_50677_));
        BlockPos start = startPos.m_7918_(1, 1, 0);
        BlockPos end = start.m_7918_(size.m_123341_(), 0, size.m_123343_());
        for (int x = 1; x <= size.m_123341_() - 1; ++x) {
            for (int z = 1; z <= size.m_123343_() - 1; ++z) {
                if (!world.m_46859_(start.m_7918_(x, 0, z)) || rand.m_188503_(12) != 0) continue;
                world.m_7731_(start.m_7918_(x, 0, z), Blocks.f_50033_.m_49966_(), flags);
            }
        }
        BlockPos inner = start.m_7918_(2, 0, 2);
        BlockPos bound = end.m_7918_(-2, 0, -2);
        BlockPos innerSize = new BlockPos(bound.m_123341_() - inner.m_123341_(), bound.m_123342_() - inner.m_123342_(), bound.m_123343_() - inner.m_123343_());
        BlockPos fixed = inner.m_7918_((rotation == Rotation.CLOCKWISE_180 ? graveSize.m_123341_() : 0) + (mirror == Mirror.FRONT_BACK ? transformedGraveSize.m_123341_() - 1 : 0) * (rotation == Rotation.CLOCKWISE_180 ? -1 : 1), 0, (rotation == Rotation.COUNTERCLOCKWISE_90 ? graveSize.m_123343_() : 0) + (mirror == Mirror.FRONT_BACK ? transformedGraveSize.m_123343_() - 1 : 0) * (rotation == Rotation.COUNTERCLOCKWISE_90 ? -1 : 1));
        BlockPos fixedSize = innerSize.m_7918_(-graveSize.m_123341_(), 0, -graveSize.m_123343_());
        BlockPos chestloc = new BlockPos(rand.m_188503_(2) - (mirror == Mirror.FRONT_BACK ? 1 : 0), 1, 0).m_7954_(rotation);
        for (int x = 0; x <= fixedSize.m_123341_(); x += rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90 ? 2 : 5) {
            for (int z = 0; z <= fixedSize.m_123343_(); z += rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180 ? 2 : 5) {
                if (x == innerSize.m_123341_() / 2 || z == innerSize.m_123343_() / 2) continue;
                BlockPos placement = fixed.m_7918_(x, -2, z);
                Pair grave = (Pair)graves.get(rand.m_188503_(graves.size()));
                ((StructureTemplate)grave.getValue()).m_230328_((ServerLevelAccessor)world, placement, placement, placementsettings, rand, flags);
                data.addAll(((StructureTemplate)grave.getValue()).m_74603_(placement, placementsettings, Blocks.f_50677_));
                if (grave.getKey() != GraveType.Full || !rand.m_188499_()) continue;
                if (rand.m_188503_(3) == 0) {
                    placement = placement.m_121955_((Vec3i)new BlockPos(mirror == Mirror.FRONT_BACK ? 1 : -1, 0, mirror == Mirror.LEFT_RIGHT ? 1 : -1).m_7954_(rotation));
                    trap.m_230328_((ServerLevelAccessor)world, placement, placement, placementsettings, rand, flags);
                }
                data.addAll(trap.m_74603_(placementPos, placementsettings, Blocks.f_50677_));
                if (world.m_7731_(placement.m_121955_((Vec3i)chestloc), ((BlockState)Blocks.f_50325_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.WEST)).m_60717_(rotation).m_60715_(mirror), flags)) {
                    TFLootTables.GRAVEYARD.generateChestContents(world, placement.m_121955_((Vec3i)chestloc));
                    world.m_7731_(placement.m_121955_((Vec3i)chestloc).m_7495_(), Blocks.f_50079_.m_49966_(), 3);
                }
                Wraith wraith = new Wraith((EntityType<? extends Wraith>)((EntityType)TFEntities.WRAITH.get()), (Level)world.m_6018_());
                wraith.m_6034_(placement.m_123341_(), placement.m_123342_(), placement.m_123343_());
                wraith.m_6518_((ServerLevelAccessor)world, world.m_6436_(placement), MobSpawnType.STRUCTURE, null, null);
                world.m_7967_((Entity)wraith);
            }
        }
        data.forEach(info -> {
            if (info.f_74677_ != null && StructureMode.valueOf((String)info.f_74677_.m_128461_("mode")) == StructureMode.DATA) {
                String s = info.f_74677_.m_128461_("metadata");
                BlockPos p = info.f_74675_;
                if ("spawner".equals(s)) {
                    SpawnerBlockEntity ms;
                    world.m_7471_(p, false);
                    if (rand.m_188503_(4) == 0 && world.m_7731_(p, Blocks.f_50085_.m_49966_(), 3) && (ms = (SpawnerBlockEntity)world.m_7702_(p)) != null) {
                        ms.m_252803_((EntityType)TFEntities.RISING_ZOMBIE.get(), rand);
                    }
                }
            }
        });
        return true;
    }

    private static enum GraveType {
        Full(TwilightForestMod.prefix("feature/graveyard/grave_full")),
        Upper(TwilightForestMod.prefix("feature/graveyard/grave_upper")),
        Lower(TwilightForestMod.prefix("feature/graveyard/grave_lower"));

        private static final GraveType[] VALUES;
        private final ResourceLocation RL;

        private GraveType(ResourceLocation rl) {
            this.RL = rl;
        }

        static {
            VALUES = GraveType.values();
        }
    }

    public static class WebTemplateProcessor
    extends StructureProcessor {
        public static final WebTemplateProcessor INSTANCE = new WebTemplateProcessor();
        public static final Codec<WebTemplateProcessor> CODEC = Codec.unit(() -> INSTANCE);

        private WebTemplateProcessor() {
        }

        protected StructureProcessorType<?> m_6953_() {
            return (StructureProcessorType)TFStructureProcessors.WEB.get();
        }

        @Nullable
        public StructureTemplate.StructureBlockInfo process(LevelReader worldIn, BlockPos pos, BlockPos piecepos, StructureTemplate.StructureBlockInfo p_process_3_, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
            return blockInfo.f_74676_.m_60734_() == Blocks.f_50440_ ? blockInfo : (settings.m_230326_(pos).m_188503_(5) == 0 ? new StructureTemplate.StructureBlockInfo(pos, Blocks.f_50033_.m_49966_(), null) : blockInfo);
        }
    }
}

