/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.templates;

import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateFeature<T extends FeatureConfiguration>
extends Feature<T> {
    public TemplateFeature(Codec<T> config) {
        super(config);
    }

    public final boolean m_142674_(FeaturePlaceContext<T> ctx) {
        int dz;
        WorldGenLevel world = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        RandomSource random = world.m_213780_();
        FeatureConfiguration config = ctx.m_159778_();
        StructureTemplateManager templateManager = world.m_6018_().m_7654_().m_236738_();
        StructureTemplate template = this.getTemplate(templateManager, random);
        if (template == null) {
            return false;
        }
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        Mirror mirror = (Mirror)Util.m_214670_((Object[])Mirror.values(), (RandomSource)random);
        ChunkPos chunkpos = new ChunkPos(pos);
        BoundingBox structureMask = new BoundingBox(chunkpos.m_45604_(), world.m_141937_(), chunkpos.m_45605_(), chunkpos.m_45608_(), world.m_151558_(), chunkpos.m_45609_());
        BlockPos posSnap = chunkpos.m_45615_().m_7918_(0, pos.m_123342_(), 0);
        Vec3i transformedSize = template.m_163808_(rotation);
        int dx = random.m_188503_(16 - transformedSize.m_123341_());
        BlockPos.MutableBlockPos startPos = new BlockPos.MutableBlockPos((posSnap = posSnap.m_7918_(dx, 0, dz = random.m_188503_(16 - transformedSize.m_123343_()))).m_123341_(), posSnap.m_123342_(), posSnap.m_123343_());
        if (!TemplateFeature.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        startPos.m_122184_(0, this.yLevelOffset(), 0);
        BlockPos placementPos = template.m_74583_((BlockPos)startPos, mirror, rotation);
        StructurePlaceSettings placementSettings = new StructurePlaceSettings().m_74377_(mirror).m_74379_(rotation).m_74381_(structureMask).m_230324_(random);
        this.modifySettings(placementSettings.m_74394_(), random, config);
        template.m_230328_((ServerLevelAccessor)world, placementPos, placementPos, placementSettings, random, 20);
        for (StructureTemplate.StructureBlockInfo info : template.m_74603_(placementPos, placementSettings, Blocks.f_50677_)) {
            if (info.f_74677_ == null || StructureMode.valueOf((String)info.f_74677_.m_128461_("mode")) != StructureMode.DATA) continue;
            this.processMarkers(info, world, rotation, mirror, random);
        }
        this.postPlacement(world, random, templateManager, rotation, mirror, placementSettings, placementPos, config);
        return true;
    }

    @Nullable
    protected abstract StructureTemplate getTemplate(StructureTemplateManager var1, RandomSource var2);

    protected void modifySettings(StructurePlaceSettings settings, RandomSource random, T config) {
    }

    protected void processMarkers(StructureTemplate.StructureBlockInfo info, WorldGenLevel world, Rotation rotation, Mirror mirror, RandomSource random) {
    }

    protected void postPlacement(WorldGenLevel world, RandomSource random, StructureTemplateManager templateManager, Rotation rotation, Mirror mirror, StructurePlaceSettings placementSettings, BlockPos placementPos, T config) {
    }

    protected int yLevelOffset() {
        return 0;
    }

    private static boolean offsetToAverageGroundLevel(WorldGenLevel world, BlockPos.MutableBlockPos startPos, Vec3i size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.m_123341_(); ++dx) {
            for (int dz = 0; dz < size.m_123343_(); ++dz) {
                int y;
                int x = startPos.m_123341_() + dx;
                int z = startPos.m_123343_() + dz;
                for (y = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z); y >= 0; --y) {
                    BlockState state = world.m_8055_(new BlockPos(x, y, z));
                    if (TemplateFeature.isBlockNotOk(state)) {
                        return false;
                    }
                    if (TemplateFeature.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)(heights.mean() + 0.5);
        int maxY = (int)heights.max();
        startPos.m_142448_(baseY);
        return TemplateFeature.isAreaClear((LevelAccessor)world, startPos.m_6630_(maxY - baseY + 1), startPos.m_121955_(size));
    }

    private static boolean isAreaClear(LevelAccessor world, BlockPos min, BlockPos max) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            if (world.m_8055_(pos).m_60767_().m_76336_()) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockOk(BlockState state) {
        Material material = state.m_60767_();
        return material == Material.f_76278_ || material == Material.f_76314_ || material == Material.f_76315_ || material == Material.f_76317_;
    }

    private static boolean isBlockNotOk(BlockState state) {
        Material material = state.m_60767_();
        return material == Material.f_76305_ || material == Material.f_76307_ || state.m_60734_() == Blocks.f_50752_;
    }

    private static boolean isDataBlock(StructureTemplate.StructureBlockInfo info) {
        return StructureMode.DATA.name().equals(info.f_74677_.m_128461_("mode"));
    }
}

