/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.CanopyTreeFeature;

@ParametersAreNonnullByDefault
public class OakCanopyTreeFeature
extends CanopyTreeFeature {
    public OakCanopyTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, BiConsumer<BlockPos, BlockState> decorationPlacer, TFTreeFeatureConfig config) {
        ArrayList leaves = Lists.newArrayList();
        int treeHeight = config.minHeight;
        if (random.m_188503_(config.chanceAddFiveFirst) == 0) {
            treeHeight += random.m_188503_(treeHeight / 2);
            if (random.m_188503_(config.chanceAddFiveSecond) == 0) {
                treeHeight += random.m_188503_(5);
            }
        }
        if (world.m_151562_(pos.m_123342_() + treeHeight)) {
            return false;
        }
        BlockState state = world.m_8055_(pos.m_7495_());
        if (!state.m_60734_().canSustainPlant(state, (BlockGetter)world, pos.m_7495_(), Direction.UP, (IPlantable)TFBlocks.CANOPY_SAPLING.get())) {
            return false;
        }
        leaves.clear();
        this.buildTrunk((LevelAccessor)world, leaves, trunkPlacer, random, pos, treeHeight, config);
        int numBranches = 12 + random.m_188503_(9);
        float bangle = random.m_188501_();
        for (int b = 0; b < numBranches; ++b) {
            float btilt = 0.15f + random.m_188501_() * 0.35f;
            this.buildBranch((LevelAccessor)world, leaves, pos, trunkPlacer, treeHeight - 10 + b / 2, 5.0, bangle, btilt, false, random, config);
            bangle += random.m_188501_() * 0.4f;
            if (!(bangle > 1.0f)) continue;
            bangle -= 1.0f;
        }
        for (BlockPos leafPos : leaves) {
            this.makeLeafBlob((LevelSimulatedReader)world, leavesPlacer, random, leafPos, config);
        }
        OakCanopyTreeFeature.makeRoots((LevelAccessor)world, trunkPlacer, decorationPlacer, random, pos, config);
        OakCanopyTreeFeature.makeRoots((LevelAccessor)world, trunkPlacer, decorationPlacer, random, pos.m_122029_(), config);
        OakCanopyTreeFeature.makeRoots((LevelAccessor)world, trunkPlacer, decorationPlacer, random, pos.m_122019_(), config);
        OakCanopyTreeFeature.makeRoots((LevelAccessor)world, trunkPlacer, decorationPlacer, random, pos.m_122029_().m_122019_(), config);
        return true;
    }

    private void makeLeafBlob(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> leafPlacer, RandomSource rand, BlockPos leafPos, TFTreeFeatureConfig config) {
        FeaturePlacers.placeSpheroid(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, rand, leafPos, 2.5f, 2.5f, config.leavesProvider);
    }

    private static void makeRoots(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> decoPlacer, RandomSource random, BlockPos pos, TFTreeFeatureConfig config) {
        if (FeatureUtil.hasAirAround(world, pos.m_7495_())) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pos.m_7495_(), config.trunkProvider);
        } else {
            FeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, decoPlacer, random, pos.m_7495_(), config.rootsProvider);
        }
        int numRoots = 1 + random.m_188503_(2);
        float offset = random.m_188501_();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot(world, decoPlacer, random, pos, offset, b, config.rootsProvider);
        }
    }

    private void buildTrunk(LevelAccessor world, List<BlockPos> leaves, BiConsumer<BlockPos, BlockState> trunkPlacer, RandomSource rand, BlockPos pos, int treeHeight, TFTreeFeatureConfig config) {
        Direction direction;
        Direction.Axis axis;
        for (int dy = 0; dy < treeHeight; ++dy) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos.m_7918_(0, dy, 0), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos.m_7918_(1, dy, 0), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos.m_7918_(0, dy, 1), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos.m_7918_(1, dy, 1), config.trunkProvider);
        }
        if (rand.m_188503_(3) == 0 && (axis = (direction = Direction.m_235672_((RandomSource)rand)).m_122434_()) != Direction.Axis.Y) {
            BlockPos.MutableBlockPos bugPos = new BlockPos.MutableBlockPos();
            bugPos.m_122190_((Vec3i)pos.m_7918_(direction == Direction.EAST ? 1 : 0, rand.m_188503_(treeHeight) / 2 + 10, direction == Direction.SOUTH ? 1 : 0));
            bugPos.m_122173_(direction).m_122184_(axis == Direction.Axis.Z ? rand.m_188503_(2) : 0, 0, axis == Direction.Axis.X ? rand.m_188503_(2) : 0);
            if (!world.m_8055_((BlockPos)bugPos).m_60804_((BlockGetter)world, (BlockPos)bugPos)) {
                BlockState bugState = (BlockState)((Block)TFBlocks.FIREFLY.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)direction);
                this.m_5974_((LevelWriter)world, (BlockPos)bugPos, bugState);
            }
        }
        leaves.add(pos.m_7918_(0, treeHeight, 0));
    }

    @Override
    void buildBranch(LevelAccessor world, List<BlockPos> leaves, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, int height, double length, double angle, double tilt, boolean trunk, RandomSource treeRNG, TFTreeFeatureConfig config) {
        BlockPos src = pos.m_6630_(height);
        BlockPos dest = FeatureLogic.translate(src, length, angle, tilt);
        int limit = 5;
        if (dest.m_123341_() - pos.m_123341_() < -limit) {
            dest = new BlockPos(pos.m_123341_() - limit, dest.m_123342_(), dest.m_123343_());
        }
        if (dest.m_123341_() - pos.m_123341_() > limit) {
            dest = new BlockPos(pos.m_123341_() + limit, dest.m_123342_(), dest.m_123343_());
        }
        if (dest.m_123343_() - pos.m_123343_() < -limit) {
            dest = new BlockPos(dest.m_123341_(), dest.m_123342_(), pos.m_123343_() - limit);
        }
        if (dest.m_123343_() - pos.m_123343_() > limit) {
            dest = new BlockPos(dest.m_123341_(), dest.m_123342_(), pos.m_123343_() + limit);
        }
        if (trunk) {
            FeaturePlacers.drawBresenhamTree((LevelSimulatedReader)world, trunkPlacer, FeaturePlacers.VALID_TREE_POS, src, dest, config.trunkProvider, treeRNG);
        } else {
            FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, treeRNG, src, dest, config.branchProvider);
        }
        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, treeRNG, dest.m_122029_(), config.branchProvider);
        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, treeRNG, dest.m_122024_(), config.branchProvider);
        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, treeRNG, dest.m_122012_(), config.branchProvider);
        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, treeRNG, dest.m_122019_(), config.branchProvider);
        leaves.add(dest);
    }
}

