/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.util.FeatureLogic;
import twilightforest.util.VoxelBresenhamIterator;
import twilightforest.world.components.feature.trees.treeplacers.BranchesConfig;

public class BranchingTrunkPlacer
extends TrunkPlacer {
    public static final Codec<BranchingTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BranchingTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.intRange((int)0, (int)24).fieldOf("branch_start_offset_down").forGetter(o -> o.branchDownwardOffset), (App)BranchesConfig.CODEC.fieldOf("branch_config").forGetter(o -> o.branchesConfig), (App)Codec.BOOL.fieldOf("perpendicular_branches").forGetter(o -> o.perpendicularBranches))).apply((Applicative)instance, BranchingTrunkPlacer::new));
    private final int branchDownwardOffset;
    private final BranchesConfig branchesConfig;
    private final boolean perpendicularBranches;

    public BranchingTrunkPlacer(int baseHeight, int randomHeightA, int randomHeightB, int branchDownwardOffset, BranchesConfig branchesConfig, boolean perpendicularBranches) {
        super(baseHeight, randomHeightA, randomHeightB);
        this.branchDownwardOffset = branchDownwardOffset;
        this.branchesConfig = branchesConfig;
        this.perpendicularBranches = perpendicularBranches;
    }

    protected TrunkPlacerType<BranchingTrunkPlacer> m_7362_() {
        return (TrunkPlacerType)TFFeatureModifiers.TRUNK_BRANCHING.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration treeConfig) {
        ArrayList leafAttachments = Lists.newArrayList();
        for (int y = 0; y <= height; ++y) {
            if (this.m_226187_(worldReader, worldPlacer, random, startPos.m_6630_(y), treeConfig)) continue;
            height = y;
            break;
        }
        leafAttachments.add(new FoliagePlacer.FoliageAttachment(startPos.m_6630_(height), 0, false));
        int numBranches = this.branchesConfig.branchCount + random.m_188503_(this.branchesConfig.randomAddBranches + 1);
        float offset = random.m_188501_();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(worldReader, worldPlacer, startPos, leafAttachments, height - this.branchDownwardOffset + b, this.branchesConfig.length, this.branchesConfig.spacingYaw * (double)b + (double)offset, this.branchesConfig.downwardsPitch, random, treeConfig, this.perpendicularBranches);
        }
        return leafAttachments;
    }

    private void buildBranch(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, BlockPos pos, List<FoliagePlacer.FoliageAttachment> leafBlocks, int height, double length, double angle, double tilt, RandomSource treeRNG, TreeConfiguration treeConfig, boolean perpendicularBranches) {
        BlockPos src = pos.m_6630_(height);
        BlockPos dest = FeatureLogic.translate(src, length, angle, tilt);
        if (perpendicularBranches) {
            this.drawBresenhamBranch(worldReader, worldPlacer, treeRNG, src, new BlockPos(dest.m_123341_(), src.m_123342_(), dest.m_123343_()), treeConfig);
            int max = Math.max(src.m_123342_(), dest.m_123342_());
            for (int i = Math.min(src.m_123342_(), dest.m_123342_()); i < max + 1; ++i) {
                this.m_226187_(worldReader, worldPlacer, treeRNG, new BlockPos(dest.m_123341_(), i, dest.m_123343_()), treeConfig);
            }
        } else {
            this.drawBresenhamBranch(worldReader, worldPlacer, treeRNG, src, dest, treeConfig);
        }
        this.m_226187_(worldReader, worldPlacer, treeRNG, dest.m_122029_(), treeConfig);
        this.m_226187_(worldReader, worldPlacer, treeRNG, dest.m_122024_(), treeConfig);
        this.m_226187_(worldReader, worldPlacer, treeRNG, dest.m_122019_(), treeConfig);
        this.m_226187_(worldReader, worldPlacer, treeRNG, dest.m_122012_(), treeConfig);
        leafBlocks.add(new FoliagePlacer.FoliageAttachment(dest, 0, false));
    }

    private void drawBresenhamBranch(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, RandomSource random, BlockPos from, BlockPos to, TreeConfiguration config) {
        for (BlockPos pixel : new VoxelBresenhamIterator(from, to)) {
            this.m_226187_(worldReader, worldPlacer, random, pixel, config);
        }
    }
}

