/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.VoxelBresenhamIterator;

public class TreeRootsDecorator
extends TreeDecorator {
    private static final SimpleStateProvider EMPTY = BlockStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_());
    public static final Codec<TreeRootsDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)16).fieldOf("base_strand_count").forGetter(o -> o.strands), (App)Codec.intRange((int)0, (int)16).fieldOf("additional_random_strands").forGetter(o -> o.addExtraStrands), (App)Codec.intRange((int)0, (int)32).fieldOf("root_length").forGetter(o -> o.length), (App)BlockStateProvider.f_68747_.optionalFieldOf("exposed_roots_provider").forGetter(o -> Optional.ofNullable(o.surfaceBlock != EMPTY ? o.surfaceBlock : null)), (App)BlockStateProvider.f_68747_.fieldOf("ground_roots_provider").forGetter(o -> o.rootBlock)).apply((Applicative)instance, TreeRootsDecorator::new));
    private final int strands;
    private final int addExtraStrands;
    private final int length;
    private final BlockStateProvider surfaceBlock;
    private final BlockStateProvider rootBlock;
    private final boolean hasSurfaceRoots;

    private TreeRootsDecorator(int count, int addExtraStrands, int length, Optional<BlockStateProvider> surfaceBlock, BlockStateProvider rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = surfaceBlock.isPresent();
        this.surfaceBlock = this.hasSurfaceRoots ? surfaceBlock.get() : EMPTY;
    }

    public TreeRootsDecorator(int count, int addExtraStrands, int length, BlockStateProvider rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = false;
        this.surfaceBlock = EMPTY;
    }

    public TreeRootsDecorator(int count, int addExtraStrands, int length, BlockStateProvider surfaceBlock, BlockStateProvider rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = true;
        this.surfaceBlock = surfaceBlock;
    }

    protected TreeDecoratorType<TreeRootsDecorator> m_6663_() {
        return (TreeDecoratorType)TFFeatureModifiers.TREE_ROOTS.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        if (context.m_226068_().isEmpty()) {
            return;
        }
        int numBranches = this.strands + context.m_226067_().m_188503_(this.addExtraStrands + 1);
        float offset = context.m_226067_().m_188501_();
        BlockPos startPos = (BlockPos)context.m_226068_().get(0);
        if (this.hasSurfaceRoots) {
            for (int i = 0; i < numBranches; ++i) {
                BlockPos dest = FeatureLogic.translate(startPos.m_6625_(i + 2), this.length, 0.3 * (double)i + (double)offset, 0.8);
                FeaturePlacers.traceExposedRoot(context.m_226058_(), context.f_226046_, context.m_226067_(), this.surfaceBlock, this.rootBlock, new VoxelBresenhamIterator(startPos.m_7495_(), dest));
            }
        } else {
            for (int i = 0; i < numBranches; ++i) {
                BlockPos dest = FeatureLogic.translate(startPos.m_6625_(i + 2), this.length, 0.3 * (double)i + (double)offset, 0.8);
                FeaturePlacers.traceRoot(context.m_226058_(), context.f_226046_, context.m_226067_(), this.rootBlock, new VoxelBresenhamIterator(startPos.m_7495_(), dest));
            }
        }
    }
}

