/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import net.minecraft.core.HolderGetter;
import net.minecraft.world.level.biome.Biome;
import twilightforest.init.TFBiomes;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.traits.CastleTransformer;

public enum GenLayerTFStream implements CastleTransformer
{
    INSTANCE;

    private HolderGetter<Biome> registry;

    public GenLayerTFStream setup(HolderGetter<Biome> registry) {
        this.registry = registry;
        return this;
    }

    @Override
    public int apply(Context iNoiseRandom, int up, int left, int down, int right, int mid) {
        if (this.shouldStream(mid, left) || this.shouldStream(mid, right) || this.shouldStream(mid, down) || this.shouldStream(mid, up)) {
            return TFBiomeProvider.getBiomeId(TFBiomes.STREAM, this.registry);
        }
        return mid;
    }

    boolean shouldStream(int biome1, int biome2) {
        if (biome1 == biome2) {
            return false;
        }
        if (biome1 == -biome2) {
            return false;
        }
        int tfLake = TFBiomeProvider.getBiomeId(TFBiomes.LAKE, this.registry);
        int thornlands = TFBiomeProvider.getBiomeId(TFBiomes.THORNLANDS, this.registry);
        return !this.testEitherBiomeOR(biome1, biome2, tfLake, tfLake) && !this.testEitherBiomeOR(biome1, biome2, thornlands, thornlands) && !this.testEitherBiomeOR(biome1, biome2, TFBiomeProvider.getBiomeId(TFBiomes.CLEARING, this.registry), TFBiomeProvider.getBiomeId(TFBiomes.OAK_SAVANNAH, this.registry)) && !this.testEitherBiomeAND(biome1, biome2, TFBiomeProvider.getBiomeId(TFBiomes.SNOWY_FOREST, this.registry), TFBiomeProvider.getBiomeId(TFBiomes.GLACIER, this.registry)) && !this.testEitherBiomeAND(biome1, biome2, TFBiomeProvider.getBiomeId(TFBiomes.MUSHROOM_FOREST, this.registry), TFBiomeProvider.getBiomeId(TFBiomes.DENSE_MUSHROOM_FOREST, this.registry)) && !this.testEitherBiomeAND(biome1, biome2, TFBiomeProvider.getBiomeId(TFBiomes.SWAMP, this.registry), TFBiomeProvider.getBiomeId(TFBiomes.FIRE_SWAMP, this.registry)) && !this.testEitherBiomeAND(biome1, biome2, TFBiomeProvider.getBiomeId(TFBiomes.DARK_FOREST, this.registry), TFBiomeProvider.getBiomeId(TFBiomes.DARK_FOREST_CENTER, this.registry)) && !this.testEitherBiomeAND(biome1, biome2, TFBiomeProvider.getBiomeId(TFBiomes.HIGHLANDS, this.registry), TFBiomeProvider.getBiomeId(TFBiomes.FINAL_PLATEAU, this.registry));
    }

    private boolean testEitherBiomeAND(int test1, int test2, int predicate1, int predicate2) {
        return test1 == predicate1 && test2 == predicate2 || test2 == predicate1 && test1 == predicate2;
    }

    private boolean testEitherBiomeOR(int test1, int test2, int predicate1, int predicate2) {
        return test1 == predicate1 || test2 == predicate2 || test2 == predicate1 || test1 == predicate2;
    }
}

