/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.trollcave;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFConfiguredFeatures;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;

public class TrollCaveGardenComponent
extends TrollCaveMainComponent {
    public TrollCaveGardenComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFTCGard.get(), nbt);
    }

    public TrollCaveGardenComponent(int index, int x, int y, int z, int caveSize, int caveHeight, Direction direction) {
        super((StructurePieceType)TFStructurePieceTypes.TFTCGard.get(), index, x, y, z);
        this.size = caveSize;
        this.height = caveHeight;
        this.m_73519_(direction);
        this.f_73383_ = TFLandmark.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction, false);
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos.MutableBlockPos dest;
        int i;
        Predicate<Biome> highlands = biome -> biome == world.m_8891_().m_175515_(Registries.f_256952_).m_6246_(TFBiomes.HIGHLANDS);
        if (this.isBoundingBoxOutsideBiomes(world, highlands)) {
            return;
        }
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        RandomSource decoRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L));
        this.makeTreasureCrate(world, sbb);
        for (i = 0; i < 24; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, generator, TFConfiguredFeatures.TROLL_CAVE_DIRT, decoRNG, dest.m_123341_(), 0, dest.m_123343_(), sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, generator, TFConfiguredFeatures.TROLL_CAVE_MYCELIUM, decoRNG, dest.m_123341_(), 0, dest.m_123343_(), sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, generator, TFConfiguredFeatures.UBEROUS_SOIL_PATCH_SMALL, decoRNG, dest.m_123341_(), 0, dest.m_123343_(), sbb);
            this.generateAtSurface(world, generator, TFConfiguredFeatures.UBEROUS_SOIL_PATCH_SMALL, decoRNG, dest.m_123341_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < 8; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.setBlockStateRotated(world, Blocks.f_50195_.m_49966_(), dest.m_123341_(), dest.m_142448_(0).m_123342_(), dest.m_123343_(), this.f_73379_, sbb);
            this.generate(world, generator, TFConfiguredFeatures.BIG_MUSHGLOOM, decoRNG, dest.m_123341_(), dest.m_142448_(1).m_123342_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.setBlockStateRotated(world, Blocks.f_50195_.m_49966_(), dest.m_123341_(), dest.m_142448_(0).m_123342_(), dest.m_123343_(), this.f_73379_, sbb);
            this.generate(world, generator, rand.m_188499_() ? TreeFeatures.f_195121_ : TreeFeatures.f_195122_, decoRNG, dest.m_123341_(), dest.m_142448_(1).m_123342_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < 128; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, BlockSpikeFeature.STONE_STALACTITE, (Vec3i)dest.m_175288_(this.height), sbb, true);
        }
    }

    protected void generate(WorldGenLevel world, ChunkGenerator generator, ResourceKey<ConfiguredFeature<?, ?>> feature, RandomSource rand, int x, int y, int z, BoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos)) {
            ((ConfiguredFeature)world.m_8891_().m_175515_(Registries.f_256911_).m_6246_(feature)).m_224953_(world, generator, rand, pos);
        }
    }
}

