/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.components.structures.util.ConfigurableSpawns;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.LandmarkStructure;

public class HollowHillStructure
extends LandmarkStructure
implements ConfigurableSpawns {
    public static final Codec<HollowHillStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)3).fieldOf("hill_size").forGetter(s -> s.size), (App)ControlledSpawns.ControlledSpawningConfig.FLAT_CODEC.forGetter(s -> s.controlledSpawningConfig)).and(HollowHillStructure.landmarkCodec(instance)).apply((Applicative)instance, HollowHillStructure::new));
    private final int size;
    private final ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig;

    public HollowHillStructure(int size, ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(decorationConfig, structureSettings);
        this.size = size;
        this.controlledSpawningConfig = controlledSpawningConfig;
    }

    public boolean canSpawnMob(BlockPos spawnPos, BoundingBox structureStartBox) {
        float hZ;
        float hY;
        float hX = Mth.m_184655_((float)spawnPos.m_123341_(), (float)structureStartBox.m_162395_(), (float)structureStartBox.m_162399_()) * 2.0f - 1.0f;
        return Mth.m_184648_((double)hX, (double)(hY = Mth.m_184655_((float)spawnPos.m_123342_(), (float)structureStartBox.m_162396_(), (float)structureStartBox.m_162400_())), (double)(hZ = Mth.m_184655_((float)spawnPos.m_123343_(), (float)structureStartBox.m_162398_(), (float)structureStartBox.m_162401_()) * 2.0f - 1.0f)) < (double)0.975f;
    }

    @Override
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return switch (this.size) {
            case 1 -> new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 3, y - 2, z - 3);
            case 2 -> new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 7, y - 5, z - 7);
            default -> new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 11, y - 5, z - 11);
        };
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TFStructureTypes.HOLLOW_HILL.get();
    }

    @Override
    public ControlledSpawns.ControlledSpawningConfig getConfig() {
        return this.controlledSpawningConfig;
    }

    public static HollowHillStructure buildSmallHillConfig(BootstapContext<Structure> context) {
        return new HollowHillStructure(1, ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 10, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 10, 4, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP.get(), 10, 4, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SWARM_SPIDER.get(), 10, 4, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 4, 8))), List.of(), List.of()), new DecorationClearance.DecorationConfig(1, true, false, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE));
    }

    public static HollowHillStructure buildMediumHillConfig(BootstapContext<Structure> context) {
        return new HollowHillStructure(2, ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP_SAPPER.get(), 1, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 10, 2, 3), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SWARM_SPIDER.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 10, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.FIRE_BEETLE.get(), 5, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SLIME_BEETLE.get(), 5, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 1, 1, 1))), List.of(), List.of()), new DecorationClearance.DecorationConfig(2, true, false, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE));
    }

    public static HollowHillStructure buildLargeHillConfig(BootstapContext<Structure> context) {
        return new HollowHillStructure(3, ControlledSpawns.ControlledSpawningConfig.firstIndexMonsters(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP_SAPPER.get(), 2, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 10, 2, 3), new MobSpawnSettings.SpawnerData(EntityType.f_20554_, 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 10, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 1, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.WRAITH.get(), 2, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.FIRE_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SLIME_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.PINCH_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 1, 1, 1)), new DecorationClearance.DecorationConfig(3, true, false, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE));
    }
}

