/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ConquerableStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class KnightStrongholdStructure
extends ConquerableStructure {
    public static final Codec<KnightStrongholdStructure> CODEC = RecordCodecBuilder.create(instance -> KnightStrongholdStructure.conquerStatusCodec(instance).apply((Applicative)instance, KnightStrongholdStructure::new));

    public KnightStrongholdStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(controlledSpawningConfig, advancementLockConfig, hintConfig, decorationConfig, structureSettings);
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return new StrongholdEntranceComponent(0, x, y + 5, z);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TFStructureTypes.KNIGHT_STRONGHOLD.get();
    }

    public static KnightStrongholdStructure buildKnightStrongholdConfig(BootstapContext<Structure> context) {
        return new KnightStrongholdStructure(ControlledSpawns.ControlledSpawningConfig.firstIndexMonsters(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.BLOCKCHAIN_GOBLIN.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.LOWER_GOBLIN_KNIGHT.get(), 5, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.HELMET_CRAB.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SLIME_BEETLE.get(), 10, 2, 3), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP_SAPPER.get(), 2, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 5, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 5, 4, 4)), new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_trophy_pedestal"))), new StructureHints.HintConfig(StructureHints.HintConfig.book("tfstronghold", 5), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(3, true, false, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_KNIGHT_STRONGHOLD_BIOMES), Map.of(), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY));
    }
}

