/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ConfigurableSpawns;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.ProgressionStructure;
import twilightforest.world.components.structures.util.StructureHints;

public class TrollCaveStructure
extends ProgressionStructure
implements ConfigurableSpawns {
    public static final Codec<TrollCaveStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ControlledSpawns.ControlledSpawningConfig.FLAT_CODEC.forGetter(ConfigurableSpawns::getConfig)).and(TrollCaveStructure.progressionCodec(instance)).apply((Applicative)instance, TrollCaveStructure::new));
    private final ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig;

    public TrollCaveStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(advancementLockConfig, hintConfig, decorationConfig, structureSettings);
        this.controlledSpawningConfig = controlledSpawningConfig;
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return new TrollCaveMainComponent((StructurePieceType)TFStructurePieceTypes.TFTCMai.get(), 0, x, y, z);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TFStructureTypes.TROLL_CAVE.get();
    }

    @Override
    public ControlledSpawns.ControlledSpawningConfig getConfig() {
        return this.controlledSpawningConfig;
    }

    @Override
    protected boolean dontCenter() {
        return true;
    }

    public static TrollCaveStructure buildTrollCaveConfig(BootstapContext<Structure> context) {
        return new TrollCaveStructure(ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 5, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.TROLL.get(), 20, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 5, 1, 1)), List.of(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.GIANT_MINER.get(), 10, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.ARMORED_GIANT.get(), 10, 1, 1))), List.of(), List.of()), new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_merge"))), new StructureHints.HintConfig(StructureHints.HintConfig.book("trollcave", 3), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(4, true, true, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_TROLL_CAVE_BIOMES), Map.of(), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY));
    }
}

