/*
 * Decompiled with CFR 0.152.
 */
package com.bailym.extraarmor.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ArmorConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enableCactus;
        public final ForgeConfigSpec.BooleanValue enableObsidian;
        public final ForgeConfigSpec.BooleanValue enableMolten;
        public final ForgeConfigSpec.BooleanValue enablePhantom;
        public final ForgeConfigSpec.BooleanValue enableGhost;
        public final ForgeConfigSpec.BooleanValue enableCryingObsidian;
        public final ForgeConfigSpec.BooleanValue enableIce;
        public final ForgeConfigSpec.BooleanValue enableGlowstone;
        public final ForgeConfigSpec.BooleanValue enablePrismarineShard;
        public final ForgeConfigSpec.BooleanValue enablePrismarineCrystal;
        public final ForgeConfigSpec.BooleanValue enableEmerald;
        public final ForgeConfigSpec.BooleanValue enableEnder;
        public final ForgeConfigSpec.BooleanValue enableFeather;
        public final ForgeConfigSpec.BooleanValue enableSlime;
        public final ForgeConfigSpec.BooleanValue enableLapis;
        public final ForgeConfigSpec.BooleanValue enableCrimsonWood;
        public final ForgeConfigSpec.BooleanValue enableWarpedWood;
        public final ForgeConfigSpec.BooleanValue enableReinforcedIron;
        public final ForgeConfigSpec.BooleanValue enableGlowingObsidian;
        public final ForgeConfigSpec.BooleanValue enableEnderghost;
        public final ForgeConfigSpec.BooleanValue enableEchoShard;
        public final ForgeConfigSpec.IntValue cactusLevel;
        public final ForgeConfigSpec.IntValue cryingObsidianLevel;
        public final ForgeConfigSpec.IntValue emeraldLevel;
        public final ForgeConfigSpec.IntValue enderLevel;
        public final ForgeConfigSpec.IntValue featherLevel;
        public final ForgeConfigSpec.IntValue ghostLevel;
        public final ForgeConfigSpec.IntValue iceLevel;
        public final ForgeConfigSpec.IntValue obsidianLevel;
        public final ForgeConfigSpec.IntValue prismarineCrystalLevel;
        public final ForgeConfigSpec.IntValue slimeLevel;
        public final ForgeConfigSpec.IntValue echoShardLevel;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Extra Armor Config - Requires Client Restart!").push("Enable or Disable Set Bonuses (true = enabled, false = disabled)");
            this.enableCactus = builder.comment("Enable or Disable Cactus Armor Effects").worldRestart().define("enableCactus", true);
            this.enableObsidian = builder.comment("Enable or Disable Obsidian Armor Effects").worldRestart().define("enableObsidian", true);
            this.enableMolten = builder.comment("Enable or Disable Molten Armor Effects").worldRestart().define("enableMolten", true);
            this.enablePhantom = builder.comment("Enable or Disable Phantom Armor Effects").worldRestart().define("enablePhantom", true);
            this.enableGhost = builder.comment("Enable or Disable Ghost Armor Effects").worldRestart().define("enableGhost", true);
            this.enableCryingObsidian = builder.comment("Enable or Disable Crying Obsidian Armor Effects").worldRestart().define("enableCryingObsidian", true);
            this.enableIce = builder.comment("Enable or Disable Ice Armor Effects").worldRestart().define("enableIce", true);
            this.enableGlowstone = builder.comment("Enable or Disable Glowstone Armor Effects").worldRestart().define("enableGlowstone", true);
            this.enablePrismarineShard = builder.comment("Enable or Disable Prismarine Shard Armor Effects").worldRestart().define("enablePrismarineShard", true);
            this.enablePrismarineCrystal = builder.comment("Enable or Disable Prismarine Crystal Armor Effects").worldRestart().define("enablePrismarineCrystal", true);
            this.enableEmerald = builder.comment("Enable or Disable Emerald Armor Effects").worldRestart().define("enableEmerald", true);
            this.enableEnder = builder.comment("Enable or Disable Ender Armor Effects").worldRestart().define("enableEnder", true);
            this.enableFeather = builder.comment("Enable or Disable Feather Armor Effects").worldRestart().define("enableFeather", true);
            this.enableSlime = builder.comment("Enable or Disable Slime Armor Effects").worldRestart().define("enableSlime", true);
            this.enableLapis = builder.comment("Enable or Disable Lapis Armor Effects").worldRestart().define("enableLapis", true);
            this.enableCrimsonWood = builder.comment("Enable or Disable Crimson Wood Armor Effects").worldRestart().define("enableCrimsonWood", true);
            this.enableWarpedWood = builder.comment("Enable or Disable Warped Wood Armor Effects").worldRestart().define("enableWarpedWood", true);
            this.enableReinforcedIron = builder.comment("Enable or Disable Reinforced Iron Armor Effects").worldRestart().define("enableReinforcedIron", true);
            this.enableGlowingObsidian = builder.comment("Enable or Disable Glowing Obsidian Armor Effects").worldRestart().define("enableGlowingObsidian", true);
            this.enableEnderghost = builder.comment("Enable or Disable Glowing Obsidian Armor Effects").worldRestart().define("enableGlowingObsidian", true);
            this.enableEchoShard = builder.comment("Enable or Disable Echo Shard Armor Effects").worldRestart().define("enableEchoShard", true);
            builder.pop();
            builder.push("Set Effect/Enchantment Levels");
            this.cactusLevel = builder.comment("The Level of Thorns Given by the Cactus Set (Default: 1)").worldRestart().defineInRange("cactusLevel", 1, 1, 4);
            this.cryingObsidianLevel = builder.comment("The Level of Blast Protection Given by the Crying Obsidian Set (Default: 4)").worldRestart().defineInRange("cryingObsidianLevel", 4, 1, 4);
            this.emeraldLevel = builder.comment("The Level of Luck Given by the Emerald Set (Default: 2)").worldRestart().defineInRange("emeraldLevel", 2, 1, 5);
            this.enderLevel = builder.comment("The Level of Speed Given by the Ender Set (Default: 2) NOTE: Also affects combined armors").worldRestart().defineInRange("enderLevel", 2, 1, 5);
            this.featherLevel = builder.comment("The Level of Jump Boost Given by the Feather Set (Default: 2)").worldRestart().defineInRange("featherLevel", 2, 1, 5);
            this.ghostLevel = builder.comment("The Level of Soul Speed Given by the Ghost Set (Default: 2) NOTE: Also affects combined armors").worldRestart().defineInRange("ghostLevel", 2, 1, 3);
            this.iceLevel = builder.comment("The Level of Frost Walker Given by the Ice Set (Default: 2)").worldRestart().defineInRange("iceLevel", 2, 1, 2);
            this.obsidianLevel = builder.comment("The Level of Blast Protection Given by the Obsidian Set (Default: 4). NOTE: Also affects combined armors").worldRestart().defineInRange("obsidianLevel", 4, 1, 4);
            this.prismarineCrystalLevel = builder.comment("The Level of Dolphins Grace Given by the Prismarine Crystal Set (Default: 2)").worldRestart().defineInRange("prismarineCrystalLevel", 2, 1, 5);
            this.slimeLevel = builder.comment("The Level of Projectile Protection Given by the Slime Set (Default: 2)").worldRestart().defineInRange("slimeLevel", 2, 1, 4);
            this.echoShardLevel = builder.comment("The Level of Swift Sneak Given by the Slime Set (Default: 2)").worldRestart().defineInRange("slimeLevel", 2, 1, 4);
            builder.pop();
        }
    }
}

