/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.lightfall.client;

import io.izzel.lightfall.client.bridge.ClientLoginNetHandlerBridge;
import io.izzel.lightfall.client.gui.LightfallHandshakeScreen;
import io.izzel.lightfall.client.mixin.ClientPacketListenerAccessor;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.registries.GameData;

@Mod(value="lightfallclient")
public class LightfallClient {
    private static final byte[] RESET_ACK = "lightfall:ack".getBytes(StandardCharsets.UTF_8);

    public LightfallClient() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::registerChannel);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    public static class ClientSetup {
        private static void registerChannel() {
            EventNetworkChannel channel = NetworkRegistry.newEventChannel((ResourceLocation)new ResourceLocation("lightfall", "reset"), () -> "1", s -> true, s -> true);
            channel.addListener(ClientSetup::handleReset);
        }

        private static void handleReset(NetworkEvent.ServerCustomPayloadEvent event) {
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            Connection netManager = context.getNetworkManager();
            if (netManager == null || !(netManager.m_129538_() instanceof ClientGamePacketListener)) {
                return;
            }
            context.enqueueWork(() -> {
                Minecraft client = Minecraft.m_91087_();
                LightfallHandshakeScreen screen = new LightfallHandshakeScreen(netManager);
                client.m_91152_((Screen)screen);
                if (client.f_91073_ != null) {
                    GameData.revertToFrozen();
                    client.f_91073_ = null;
                }
                netManager.m_129498_(ConnectionProtocol.LOGIN);
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])RESET_ACK));
                netManager.m_129512_((Packet)new ServerboundCustomQueryPacket(0x11FFA1, buffer));
                ClientPacketListener packetListener = (ClientPacketListener)netManager.m_129538_();
                ClientHandshakePacketListenerImpl netHandler = new ClientHandshakePacketListenerImpl(netManager, client, ((ClientPacketListenerAccessor)packetListener).accessor$getServerData(), (Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()), false, null, screen::setComponent);
                ((ClientLoginNetHandlerBridge)netHandler).bridge$reusePlayHandler(packetListener);
                netManager.m_129505_((PacketListener)netHandler);
            }).join();
            context.setPacketHandled(true);
        }
    }
}

