/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.world;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;

public class ExpandedBiomes {
    private static Map<ResourceKey<LevelStem>, List<ResourceKey<Biome>>> biomes = new HashMap<ResourceKey<LevelStem>, List<ResourceKey<Biome>>>();

    public static void addExpandedBiome(ResourceKey<Biome> biome, ResourceKey<LevelStem> dimension) {
        List<Object> list = !biomes.containsKey(dimension) ? new ArrayList() : biomes.get(dimension);
        if (!list.contains(biome)) {
            list.add(biome);
        }
        biomes.put(dimension, list);
    }

    public static Set<Holder<Biome>> buildBiomeList(RegistryAccess registryAccess, ResourceKey<LevelStem> dimension) {
        List<ResourceKey<Biome>> list = biomes.get(dimension);
        if (list == null || list.isEmpty()) {
            return Set.of();
        }
        Registry allBiomes = registryAccess.m_175515_(Registries.f_256952_);
        ImmutableSet.Builder biomeHolders = ImmutableSet.builder();
        for (ResourceKey<Biome> biomeResourceKey : list) {
            Optional holderOptional = allBiomes.m_203636_(biomeResourceKey);
            holderOptional.ifPresent(arg_0 -> ((ImmutableSet.Builder)biomeHolders).add(arg_0));
        }
        return biomeHolders.build();
    }
}

