/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.PlayerUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class TeleportPacket {
    public TeleportPacket() {
    }

    public TeleportPacket(FriendlyByteBuf buf) {
    }

    public void fromBytes(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ItemUtils.getHeldItem((Player)((NetworkEvent.Context)ctx.get()).getSender(), ExplorersCompass.explorersCompass);
            if (!stack.m_41619_()) {
                ExplorersCompassItem explorersCompass = (ExplorersCompassItem)stack.m_41720_();
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (((Boolean)ConfigHandler.GENERAL.allowTeleport.get()).booleanValue() && PlayerUtils.canTeleport(player.m_20194_(), (Player)player)) {
                    if (explorersCompass.getState(stack) == CompassState.FOUND) {
                        int x = explorersCompass.getFoundStructureX(stack);
                        int z = explorersCompass.getFoundStructureZ(stack);
                        int y = this.findValidTeleportHeight(player.f_19853_, x, z);
                        player.m_8127_();
                        player.f_8906_.m_9774_((double)x, (double)y, (double)z, player.m_146908_(), player.m_146909_());
                        if (!player.m_21255_()) {
                            player.m_20334_(player.m_20184_().m_7096_(), 0.0, player.m_20184_().m_7094_());
                            player.m_6853_(true);
                        }
                    }
                } else {
                    ExplorersCompass.LOGGER.warn("Player " + player.m_5446_().getString() + " tried to teleport but does not have permission.");
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private int findValidTeleportHeight(Level level, int x, int z) {
        int upY = level.m_5736_();
        int downY = level.m_5736_();
        while (!this.isValidTeleportPosition(level, new BlockPos(x, upY, z)) && !this.isValidTeleportPosition(level, new BlockPos(x, downY, z))) {
            ++upY;
            --downY;
        }
        BlockPos upPos = new BlockPos(x, upY, z);
        BlockPos downPos = new BlockPos(x, downY, z);
        if (this.isValidTeleportPosition(level, upPos)) {
            return upY;
        }
        if (this.isValidTeleportPosition(level, downPos)) {
            return downY;
        }
        return 256;
    }

    private boolean isValidTeleportPosition(Level level, BlockPos pos) {
        return !level.m_151570_(pos) && this.isFree(level, pos) && this.isFree(level, pos.m_7494_()) && !this.isFree(level, pos.m_7495_());
    }

    private boolean isFree(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_204336_(BlockTags.f_13076_) || level.m_8055_(pos).m_60767_().m_76332_() || level.m_8055_(pos).m_60767_().m_76336_();
    }
}

