/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;

public class StructureUtils {
    public static ListMultimap<ResourceLocation, ResourceLocation> getTypeKeysToStructureKeys(ServerLevel level) {
        ArrayListMultimap typeKeysToStructureKeys = ArrayListMultimap.create();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            typeKeysToStructureKeys.put((Object)StructureUtils.getTypeForStructure(level, structure), (Object)StructureUtils.getKeyForStructure(level, structure));
        }
        return typeKeysToStructureKeys;
    }

    public static Map<ResourceLocation, ResourceLocation> getStructureKeysToTypeKeys(ServerLevel level) {
        HashMap<ResourceLocation, ResourceLocation> structureKeysToStructureKeys = new HashMap<ResourceLocation, ResourceLocation>();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            structureKeysToStructureKeys.put(StructureUtils.getKeyForStructure(level, structure), StructureUtils.getTypeForStructure(level, structure));
        }
        return structureKeysToStructureKeys;
    }

    public static ResourceLocation getTypeForStructure(ServerLevel level, Structure structure) {
        Registry<StructureSet> registry = StructureUtils.getStructureSetRegistry(level);
        for (StructureSet set : registry) {
            for (StructureSet.StructureSelectionEntry entry : set.f_210003_()) {
                if (!((Structure)entry.f_210026_().get()).equals(structure)) continue;
                return registry.m_7981_((Object)set);
            }
        }
        return new ResourceLocation("explorerscompass", "none");
    }

    public static ResourceLocation getKeyForStructure(ServerLevel level, Structure structure) {
        return StructureUtils.getStructureRegistry(level).m_7981_((Object)structure);
    }

    public static Structure getStructureForKey(ServerLevel level, ResourceLocation key) {
        return (Structure)StructureUtils.getStructureRegistry(level).m_7745_(key);
    }

    public static Holder<Structure> getHolderForStructure(ServerLevel level, Structure structure) {
        Optional optional = StructureUtils.getStructureRegistry(level).m_7854_((Object)structure);
        if (optional.isPresent()) {
            return StructureUtils.getStructureRegistry(level).m_246971_((ResourceKey)optional.get());
        }
        return null;
    }

    public static List<ResourceLocation> getAllowedStructureKeys(ServerLevel level) {
        ArrayList<ResourceLocation> structures = new ArrayList<ResourceLocation>();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            if (structure == null || StructureUtils.getKeyForStructure(level, structure) == null || StructureUtils.structureIsBlacklisted(level, structure)) continue;
            structures.add(StructureUtils.getKeyForStructure(level, structure));
        }
        return structures;
    }

    public static boolean structureIsBlacklisted(ServerLevel level, Structure structure) {
        List structureBlacklist = (List)ConfigHandler.GENERAL.structureBlacklist.get();
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getKeyForStructure(level, structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    public static List<ResourceLocation> getGeneratingDimensionKeys(ServerLevel serverLevel, Structure structure) {
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        for (ServerLevel level : serverLevel.m_7654_().m_129785_()) {
            ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
            Set biomeSet = chunkGenerator.m_62218_().m_207840_();
            if (structure.m_226559_().m_203614_().noneMatch(biomeSet::contains)) continue;
            dimensions.add(level.m_46472_().m_135782_());
        }
        if (structure == StructureType.f_226875_ && dimensions.isEmpty()) {
            dimensions.add(new ResourceLocation("minecraft:overworld"));
        }
        return dimensions;
    }

    public static ListMultimap<ResourceLocation, ResourceLocation> getGeneratingDimensionsForAllowedStructures(ServerLevel serverLevel) {
        ArrayListMultimap dimensionsForAllowedStructures = ArrayListMultimap.create();
        for (ResourceLocation structureKey : StructureUtils.getAllowedStructureKeys(serverLevel)) {
            Structure structure = StructureUtils.getStructureForKey(serverLevel, structureKey);
            dimensionsForAllowedStructures.putAll((Object)structureKey, StructureUtils.getGeneratingDimensionKeys(serverLevel, structure));
        }
        return dimensionsForAllowedStructures;
    }

    public static int getHorizontalDistanceToLocation(Player player, int x, int z) {
        return StructureUtils.getHorizontalDistanceToLocation(player.m_20183_(), x, z);
    }

    public static int getHorizontalDistanceToLocation(BlockPos startPos, int x, int z) {
        return (int)Mth.m_14116_((float)((float)startPos.m_123331_((Vec3i)new BlockPos(x, startPos.m_123342_(), z))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getPrettyStructureName(ResourceLocation key) {
        String name = key.toString();
        if (((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = I18n.m_118938_((String)Util.m_137492_((String)"structure", (ResourceLocation)key), (Object[])new Object[0]);
        }
        if (name.equals(Util.m_137492_((String)"structure", (ResourceLocation)key)) || !((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = key.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getPrettyStructureSource(ResourceLocation key) {
        if (key == null) {
            return "";
        }
        String registryEntry = key.toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String dimensionKeysToString(List<ResourceLocation> dimensions) {
        HashSet dimensionNames = new HashSet();
        dimensions.forEach(key -> dimensionNames.add(StructureUtils.getDimensionName(key)));
        return String.join((CharSequence)", ", dimensionNames);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getDimensionName(ResourceLocation dimensionKey) {
        String name = I18n.m_118938_((String)Util.m_137492_((String)"dimension", (ResourceLocation)dimensionKey), (Object[])new Object[0]);
        if (name.equals(Util.m_137492_((String)"dimension", (ResourceLocation)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    private static Registry<Structure> getStructureRegistry(ServerLevel level) {
        return level.m_8891_().m_175515_(Registries.f_256944_);
    }

    private static Registry<StructureSet> getStructureSetRegistry(ServerLevel level) {
        return level.m_8891_().m_175515_(Registries.f_256998_);
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

