/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekclib.capabilitysync.capability;

import com.sekwah.sekclib.capabilitysync.CapabilityEntry;
import com.sekwah.sekclib.capabilitysync.SyncEntry;
import com.sekwah.sekclib.capabilitysync.capability.ISyncData;
import com.sekwah.sekclib.capabilitysync.capability.SyncData;
import com.sekwah.sekclib.capabilitysync.capabilitysync.CapabilitySyncRegistry;
import com.sekwah.sekclib.capabilitysync.capabilitysync.broadcaster.CapabilityBroadcaster;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.CapabilityTracker;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.SyncTracker;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sekclib")
public class SyncDataCapabilityHandler {
    public static final Capability<ISyncData> SYNC_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISyncData>(){});

    public static void createSyncData(AttachCapabilitiesEvent<Entity> event) {
        SyncData syncData = new SyncData();
        Map registeredCaps = event.getCapabilities();
        block0: for (Map.Entry capEntry : registeredCaps.entrySet()) {
            for (CapabilityEntry capabilityEntry : CapabilitySyncRegistry.getPlayerCapabilities()) {
                Class<?> capClass = ((ICapabilityProvider)capEntry.getValue()).getClass();
                if (capabilityEntry.getCapabilityClass() != capClass) continue;
                CapabilityTracker capabilityTracker = new CapabilityTracker(capabilityEntry);
                for (SyncEntry entry : capabilityEntry.getSyncEntries()) {
                    SyncTracker syncTracker = new SyncTracker(entry);
                    capabilityTracker.addSyncTracker(syncTracker);
                }
                syncData.addCapabilityTracker(capabilityTracker);
                continue block0;
            }
        }
        event.addCapability(new ResourceLocation("sekclib", "sync_data"), (ICapabilityProvider)syncData);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!((Entity)event.getObject()).f_19853_.m_5776_()) {
            SyncDataCapabilityHandler.createSyncData(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapabilityBroadcaster.checkCapData((LivingEntity)serverPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void entityLivingUpdate(LivingEvent.LivingTickEvent event) {
        CapabilityBroadcaster.checkCapData(event.getEntity());
    }

    @SubscribeEvent
    public static void dimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapabilityBroadcaster.broadcastCapChanges((LivingEntity)serverPlayer, true);
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)player;
                CapabilityBroadcaster.broadcastCapToPlayer(livingEntity, serverPlayer);
            }
        }
    }
}

