/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekclib.capabilitysync.capabilitysync;

import com.sekwah.sekclib.SekCLib;
import com.sekwah.sekclib.capabilitysync.CapabilityEntry;
import com.sekwah.sekclib.capabilitysync.SyncEntry;
import com.sekwah.sekclib.capabilitysync.capabilitysync.annotation.Sync;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.SyncTrackerSerializer;
import com.sekwah.sekclib.registries.SekCLibRegistries;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;

public class CapabilitySyncRegistry {
    private static final Map<Class, SyncTrackerSerializer> CLASS_SYNC_TRACKER_SERIALIZER = new HashMap<Class, SyncTrackerSerializer>();

    static void registerPlayerCap(ResourceLocation resourceSyncName, Capability<?> capability, Class<?> clazz) {
        List<Field> values = Arrays.stream(clazz.getDeclaredFields()).filter(value -> value.isAnnotationPresent(Sync.class)).sorted(Comparator.comparing(Field::getName)).toList();
        CapabilityEntry capabilityEntry = new CapabilityEntry(resourceSyncName, capability, clazz);
        SekCLibRegistries.CAPABILITY_REGISTRY.register(resourceSyncName, (Object)capabilityEntry);
        ArrayList<ModLoadingException> errors = new ArrayList<ModLoadingException>();
        int trackerId = 0;
        for (Field field : values) {
            String message;
            Sync sync = field.getAnnotation(Sync.class);
            if (!CLASS_SYNC_TRACKER_SERIALIZER.containsKey(field.getType())) {
                String message2 = String.format("@Sync used on unsupported type %s. (Class: %s, Field: %s)", field.getType().getName(), clazz.getName(), field.getName());
                SekCLib.LOGGER.error(message2);
                errors.add(new ModLoadingException(null, ModLoadingStage.COMMON_SETUP, message2, null, new Object[0]));
            }
            try {
                field.setAccessible(true);
            }
            catch (UnsupportedOperationException e) {
                message = String.format("Failed to set field accessible. (Class: %s, Field: %s)", clazz.getName(), field.getName());
                SekCLib.LOGGER.error(message);
                errors.add(new ModLoadingException(null, ModLoadingStage.COMMON_SETUP, message, null, new Object[0]));
            }
            try {
                SyncEntry entry = new SyncEntry(field.getName(), field, sync.minTicks(), trackerId, sync.syncGlobally(), CLASS_SYNC_TRACKER_SERIALIZER.get(field.getType()));
                capabilityEntry.addSyncEntry(entry);
                ++trackerId;
            }
            catch (IllegalAccessException e) {
                message = String.format("There was a problem un-reflecting (Class: %s, Field: %s)", clazz.getName(), field.getName());
                SekCLib.LOGGER.error(message);
                errors.add(new ModLoadingException(null, ModLoadingStage.COMMON_SETUP, message, null, new Object[0]));
            }
        }
        if (!errors.isEmpty()) {
            throw new LoadingFailedException(errors);
        }
    }

    static void registerSyncTrackerType(Class clazz, SyncTrackerSerializer syncTracker) {
        CLASS_SYNC_TRACKER_SERIALIZER.put(clazz, syncTracker);
    }

    public static SyncTrackerSerializer getTrackerSerializer(Class clazz) {
        return CLASS_SYNC_TRACKER_SERIALIZER.get(clazz);
    }

    public static Collection<CapabilityEntry> getPlayerCapabilities() {
        return SekCLibRegistries.CAPABILITY_REGISTRY.getValues();
    }
}

